/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.seq;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorLong;
import com.googlecode.aviator.runtime.type.AviatorObject;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeqCountFunction
extends AbstractFunction {
    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1) {
        Object value = arg1.getValue(env);
        if (value == null) {
            throw new NullPointerException("null seq");
        }
        Class<?> clazz = value.getClass();
        int size = -1;
        if (Collection.class.isAssignableFrom(clazz)) {
            Collection col = (Collection)value;
            size = col.size();
        } else if (clazz.isArray()) {
            size = Array.getLength(value);
        } else {
            throw new IllegalArgumentException(arg1.desc(env) + " is not a seq collection");
        }
        return AviatorLong.valueOf(size);
    }

    @Override
    public String getName() {
        return "count";
    }
}

