/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.main;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import org.apache.felix.karaf.main.Main;

public class Utils {
    public static File getKarafHome() throws IOException {
        int start;
        String classpath;
        int index;
        URL url;
        File rc = null;
        String path = System.getProperty("karaf.home");
        if (path != null) {
            rc = Utils.validateDirectoryExists(path, "Invalid karaf.home system property");
        }
        if (rc == null && (path = System.getenv("KARAF_HOME")) != null) {
            rc = Utils.validateDirectoryExists(path, "Invalid KARAF_HOME environment variable");
        }
        if (rc == null && (url = Main.class.getClassLoader().getResource(Main.class.getName().replace(".", "/") + ".class")) != null) {
            try {
                JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                url = jarConnection.getJarFileURL();
                rc = new File(new URI(url.toString())).getCanonicalFile().getParentFile().getParentFile();
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (rc == null && (index = (classpath = System.getProperty("java.class.path")).toLowerCase().indexOf("karaf.jar")) >= (start = classpath.lastIndexOf(File.pathSeparator, index) + 1)) {
            String jarLocation = classpath.substring(start, index);
            rc = new File(jarLocation).getCanonicalFile().getParentFile();
        }
        if (rc == null) {
            throw new IOException("The Karaf install directory could not be determined.  Please set the karaf.home system property or the KARAF_HOME environment variable.");
        }
        return rc;
    }

    public static File validateDirectoryExists(String path, String errPrefix) {
        File rc;
        try {
            rc = new File(path).getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(errPrefix + " '" + path + "' : " + e.getMessage());
        }
        if (!rc.exists()) {
            throw new IllegalArgumentException(errPrefix + " '" + path + "' : does not exist");
        }
        if (!rc.isDirectory()) {
            throw new IllegalArgumentException(errPrefix + " '" + path + "' : is not a directory");
        }
        return rc;
    }

    public static File getKarafBase(File defaultValue) {
        File rc = null;
        String path = System.getProperty("karaf.base");
        if (path != null) {
            rc = Utils.validateDirectoryExists(path, "Invalid karaf.base system property");
        }
        if (rc == null && (path = System.getenv("KARAF_BASE")) != null) {
            rc = Utils.validateDirectoryExists(path, "Invalid KARAF_BASE environment variable");
        }
        if (rc == null) {
            rc = defaultValue;
        }
        return rc;
    }
}

