/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.kex;

import java.security.KeyPair;
import org.apache.sshd.common.Digest;
import org.apache.sshd.common.KeyExchange;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Signature;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.digest.SHA1;
import org.apache.sshd.common.kex.DH;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.BufferUtils;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDHGServer
implements KeyExchange {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ServerSession session;
    private byte[] V_S;
    private byte[] V_C;
    private byte[] I_S;
    private byte[] I_C;
    private Digest sha;
    private DH dh;
    private byte[] e;
    private byte[] f;
    private byte[] K;
    private byte[] H;

    public void init(AbstractSession s, byte[] V_S, byte[] V_C, byte[] I_S, byte[] I_C) throws Exception {
        if (!(s instanceof ServerSession)) {
            throw new IllegalStateException("Using a server side KeyExchange on a client");
        }
        this.session = (ServerSession)s;
        this.V_S = V_S;
        this.V_C = V_C;
        this.I_S = I_S;
        this.I_C = I_C;
        this.sha = new SHA1();
        this.sha.init();
        this.dh = new DH();
        this.initDH(this.dh);
        this.f = this.dh.getE();
    }

    protected abstract void initDH(DH var1);

    public boolean next(Buffer buffer) throws Exception {
        SshConstants.Message cmd = buffer.getCommand();
        if (cmd != SshConstants.Message.SSH_MSG_KEXDH_INIT) {
            throw new SshException(3, "Protocol error: expected packet " + (Object)((Object)SshConstants.Message.SSH_MSG_KEXDH_INIT) + ", got " + (Object)((Object)cmd));
        }
        this.log.info("Received SSH_MSG_KEXDH_INIT");
        this.e = buffer.getMPIntAsBytes();
        this.dh.setF(this.e);
        this.K = this.dh.getK();
        KeyPair kp = this.session.getHostKey();
        String algo = this.session.getNegociated(1);
        Signature sig = (Signature)NamedFactory.Utils.create(this.session.getFactoryManager().getSignatureFactories(), algo);
        sig.init(kp.getPublic(), kp.getPrivate());
        buffer = new Buffer();
        buffer.putRawPublicKey(kp.getPublic());
        byte[] K_S = buffer.getCompactData();
        buffer.clear();
        buffer.putString(this.V_C);
        buffer.putString(this.V_S);
        buffer.putString(this.I_C);
        buffer.putString(this.I_S);
        buffer.putString(K_S);
        buffer.putMPInt(this.e);
        buffer.putMPInt(this.f);
        buffer.putMPInt(this.K);
        this.sha.update(buffer.array(), 0, buffer.available());
        this.H = this.sha.digest();
        buffer.clear();
        sig.update(this.H, 0, this.H.length);
        buffer.putString(algo);
        buffer.putString(sig.sign());
        byte[] sigH = buffer.getCompactData();
        if (this.log.isDebugEnabled()) {
            this.log.debug("K_S:  {}", (Object)BufferUtils.printHex(K_S));
            this.log.debug("f:    {}", (Object)BufferUtils.printHex(this.f));
            this.log.debug("sigH: {}", (Object)BufferUtils.printHex(sigH));
        }
        this.log.info("Send SSH_MSG_KEXDH_REPLY");
        buffer.clear();
        buffer.rpos(5);
        buffer.wpos(5);
        buffer.putCommand(SshConstants.Message.SSH_MSG_KEXDH_REPLY_KEX_DH_GEX_GROUP);
        buffer.putString(K_S);
        buffer.putString(this.f);
        buffer.putString(sigH);
        this.session.writePacket(buffer);
        return true;
    }

    public Digest getHash() {
        return this.sha;
    }

    public byte[] getH() {
        return this.H;
    }

    public byte[] getK() {
        return this.K;
    }
}

