/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.dev;

import java.io.File;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.karaf.shell.console.OsgiCommandSupport;
import org.apache.felix.karaf.shell.dev.framework.Equinox;
import org.apache.felix.karaf.shell.dev.framework.Felix;
import org.apache.felix.karaf.shell.dev.framework.Framework;

@Command(scope="dev", name="framework", description="Enable/disable debugging for the OSGi Framework")
public class FrameworkDebug
extends OsgiCommandSupport {
    private static final String KARAF_BASE = System.getProperty("karaf.base");
    @Option(name="-debug", aliases={"--enable-debug"}, description="Enable debug for the OSGi framework", required=false, multiValued=false)
    boolean debug;
    @Option(name="-nodebug", aliases={"--disable-debug"}, description="Disable debug for the OSGi framework", required=false, multiValued=false)
    boolean nodebug;

    protected Object doExecute() throws Exception {
        Framework framework = this.getFramework();
        if (!this.debug ^ this.nodebug) {
            System.err.printf("Required option missing: use -debug or -nodebug%n", new Object[0]);
            return null;
        }
        if (this.debug) {
            System.out.printf("Enabling debug for OSGi framework (%s)%n", framework.getName());
            framework.enableDebug(new File(KARAF_BASE));
        }
        if (this.nodebug) {
            System.out.printf("Disabling debug for OSGi framework (%s)%n", framework.getName());
            framework.disableDebug(new File(KARAF_BASE));
        }
        return null;
    }

    public Framework getFramework() {
        if (this.bundleContext.getBundle(0L).getSymbolicName().contains("felix")) {
            return new Felix(new File(KARAF_BASE));
        }
        return new Equinox(new File(KARAF_BASE));
    }
}

