/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.log;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.felix.log.LoggerAdminImpl;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.admin.LoggerContext;

public class LoggerContextImpl
implements LoggerContext {
    static final String ROOT = "ROOT";
    private final String _name;
    protected volatile Map<String, LogLevel> _levels;
    protected final Lock _lock = new ReentrantLock();
    protected final LoggerAdminImpl _loggerAdminImpl;
    protected final LoggerContext _rootContext;
    private volatile String _toString;

    public LoggerContextImpl(String name, LoggerAdminImpl loggerAdminImpl, LoggerContext rootLoggerContext) {
        this._name = name;
        this._loggerAdminImpl = loggerAdminImpl;
        this._rootContext = rootLoggerContext;
    }

    @Override
    public String getName() {
        return this._name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogLevel getEffectiveLogLevel(String name) {
        this._lock.lock();
        try {
            if (this._levels != null && !this._levels.isEmpty()) {
                String copy = name;
                while (copy.length() > 0) {
                    LogLevel level = this._levels.get(copy);
                    if (level != null) {
                        LogLevel logLevel = level;
                        return logLevel;
                    }
                    if (ROOT.equals(copy)) break;
                    copy = this.ancestor(copy);
                }
            }
            LogLevel logLevel = this._rootContext.getEffectiveLogLevel(name);
            return logLevel;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public Map<String, LogLevel> getLogLevels() {
        this._lock.lock();
        try {
            if (this._levels == null) {
                HashMap<String, LogLevel> hashMap = new HashMap<String, LogLevel>();
                return hashMap;
            }
            HashMap<String, LogLevel> hashMap = new HashMap<String, LogLevel>(this._levels);
            return hashMap;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void setLogLevels(Map<String, LogLevel> logLevels) {
        this._lock.lock();
        try {
            this._levels = new HashMap<String, LogLevel>(logLevels);
            this._loggerAdminImpl.keepLoggerContext(this._name, this);
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void clear() {
        this._lock.lock();
        try {
            this._levels = null;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this._lock.lock();
        try {
            boolean bl = this._levels == null || this._levels.isEmpty();
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLoggerContext(Dictionary<String, Object> properties) {
        this._lock.lock();
        try {
            this._levels = new HashMap<String, LogLevel>();
            if (properties != null) {
                Enumeration<String> enu = properties.keys();
                block3: while (enu.hasMoreElements()) {
                    String key = enu.nextElement();
                    Object object = properties.get(key);
                    if (!(object instanceof String)) continue;
                    String value = (String)object;
                    for (LogLevel level : LogLevel.values()) {
                        if (!level.name().equalsIgnoreCase(value)) continue;
                        this._levels.put(key, level);
                        continue block3;
                    }
                }
            }
            this._loggerAdminImpl.keepLoggerContext(this._name, this);
        }
        finally {
            this._lock.unlock();
        }
    }

    public String toString() {
        if (this._toString == null) {
            this._toString = this.getClass().getSimpleName() + "[" + this._name + "]";
        }
        return this._toString;
    }

    protected String ancestor(String name) {
        int position = name.lastIndexOf(46);
        if (position == -1) {
            return ROOT;
        }
        return name.substring(0, position);
    }
}

