/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.helper;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.apache.felix.scrplugin.Options;
import org.apache.felix.scrplugin.Project;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.SpecVersion;
import org.apache.felix.scrplugin.description.AbstractDescription;
import org.apache.felix.scrplugin.description.ClassDescription;
import org.apache.felix.scrplugin.description.ComponentDescription;
import org.apache.felix.scrplugin.description.PropertyDescription;
import org.apache.felix.scrplugin.description.PropertyType;
import org.apache.felix.scrplugin.description.ReferenceCardinality;
import org.apache.felix.scrplugin.description.ReferenceDescription;
import org.apache.felix.scrplugin.description.ReferencePolicy;
import org.apache.felix.scrplugin.description.ReferencePolicyOption;
import org.apache.felix.scrplugin.description.ReferenceStrategy;
import org.apache.felix.scrplugin.description.ServiceDescription;
import org.apache.felix.scrplugin.helper.ComponentContainer;
import org.apache.felix.scrplugin.helper.IssueLog;
import org.apache.felix.scrplugin.helper.StringUtils;

public class Validator {
    private final ComponentContainer container;
    private final Options options;
    private final Project project;
    private final IssueLog iLog;
    private static final String TYPE_COMPONENT_CONTEXT = "org.osgi.service.component.ComponentContext";
    private static final String TYPE_BUNDLE_CONTEXT = "org.osgi.framework.BundleContext";
    private static final String TYPE_MAP = "java.util.Map";
    private static final String TYPE_INT = "int";
    private static final String TYPE_INTEGER = "java.lang.Integer";
    private static final String TYPE_SERVICE_REFERENCE = "org.osgi.framework.ServiceReference";

    public Validator(ComponentContainer container, Project project, Options options, IssueLog iLog) {
        this.container = container;
        this.project = project;
        this.options = options;
        this.iLog = iLog;
    }

    private void logWarn(AbstractDescription desc, String message) {
        String classLocation = this.container.getComponentDescription().getSource();
        if (classLocation.equals(desc.getSource())) {
            this.iLog.addWarning(desc.getIdentifier() + " : " + message, desc.getSource());
        } else {
            this.iLog.addWarning(desc.getIdentifier() + " (" + desc.getSource() + ") : " + message, classLocation);
        }
    }

    private void logError(AbstractDescription desc, String message) {
        String classLocation = this.container.getComponentDescription().getSource();
        if (classLocation.equals(desc.getSource())) {
            this.iLog.addError(desc.getIdentifier() + " : " + message, desc.getSource());
        } else {
            this.iLog.addError(desc.getIdentifier() + " (" + desc.getSource() + ") : " + message, classLocation);
        }
    }

    public void validate() throws SCRDescriptorException {
        ComponentDescription component = this.container.getComponentDescription();
        if (!component.isCreateDs()) {
            return;
        }
        int currentIssueCount = this.iLog.getNumberOfErrors();
        if (!component.isAbstract()) {
            if (component.getConfigurationPid() != null && !component.getConfigurationPid().equals(component.getName()) && this.options.getSpecVersion().ordinal() < SpecVersion.VERSION_1_2.ordinal()) {
                this.logError(component, "Different configuration pid requires " + SpecVersion.VERSION_1_2.getName() + " or higher.");
            }
            if (!Modifier.isPublic(this.container.getClassDescription().getDescribedClass().getModifiers())) {
                this.logError(component, "Class must be public: " + this.container.getClassDescription().getDescribedClass().getName());
            }
            if (Modifier.isAbstract(this.container.getClassDescription().getDescribedClass().getModifiers()) || this.container.getClassDescription().getDescribedClass().isInterface()) {
                this.logError(component, "Class must be concrete class (not abstract or interface) : " + this.container.getClassDescription().getDescribedClass().getName());
            }
            if (this.iLog.getNumberOfErrors() == currentIssueCount) {
                String activateName = component.getActivate() == null ? "activate" : component.getActivate();
                String deactivateName = component.getDeactivate() == null ? "deactivate" : component.getDeactivate();
                this.checkLifecycleMethod(activateName, true, component.getActivate() != null);
                this.checkLifecycleMethod(deactivateName, false, component.getDeactivate() != null);
                if (component.getModified() != null) {
                    if (this.options.getSpecVersion().ordinal() >= SpecVersion.VERSION_1_1.ordinal()) {
                        this.checkLifecycleMethod(component.getModified(), true, true);
                    } else {
                        this.logError(component, "If modified version is specified, spec version must be " + SpecVersion.VERSION_1_1.name() + " or higher : " + component.getModified());
                    }
                }
                boolean constructorFound = true;
                Constructor<?>[] constructors = this.container.getClassDescription().getDescribedClass().getDeclaredConstructors();
                for (int i = 0; constructors != null && i < constructors.length; ++i) {
                    if (Modifier.isPublic(constructors[i].getModifiers()) && (constructors[i].getParameterTypes() == null || constructors[i].getParameterTypes().length == 0)) {
                        constructorFound = true;
                        break;
                    }
                    constructorFound = false;
                }
                if (!constructorFound) {
                    this.logError(component, "Class must have public default constructor: " + this.container.getClassDescription().getDescribedClass().getName());
                }
                for (PropertyDescription prop : this.container.getProperties().values()) {
                    this.validateProperty(prop);
                }
                boolean isServiceFactory = false;
                if (this.container.getServiceDescription() != null) {
                    if (this.container.getServiceDescription().getInterfaces().size() == 0) {
                        this.logError(component, "Service interface information is missing!");
                    }
                    this.validateService(this.container.getServiceDescription());
                    isServiceFactory = this.container.getServiceDescription().isServiceFactory();
                }
                if (isServiceFactory && component.getImmediate() != null && component.getImmediate().booleanValue() && component.getFactory() != null) {
                    this.logError(component, "Component must not be a ServiceFactory, if immediate and/or component factory: " + this.container.getClassDescription().getDescribedClass().getName());
                }
                if (component.getImmediate() != null && component.getImmediate().booleanValue() && component.getFactory() != null) {
                    this.logError(component, "Component must not be immediate if component factory: " + this.container.getClassDescription().getDescribedClass().getName());
                }
            }
            if (this.container.getMetatypeContainer() != null && this.container.getMetatypeContainer().getProperties().size() == 0) {
                this.logError(component, "Component is defined to generate metatype information, however no properties or only private properties have been defined; in case no properties or only private properties are wanted, consider to use 'metatype=false'");
            }
            if (this.iLog.getNumberOfErrors() == currentIssueCount) {
                for (ReferenceDescription ref : this.container.getReferences().values()) {
                    this.validateReference(ref, component.isAbstract());
                }
            }
        }
    }

    private static Method getMethod(Project project, ComponentContainer container, String name, String[] sig) throws SCRDescriptorException {
        Class[] classSig;
        Class[] classArray = classSig = sig == null ? null : new Class[sig.length];
        if (sig != null) {
            for (int i = 0; i < sig.length; ++i) {
                try {
                    if (sig[i].equals(TYPE_INT)) {
                        classSig[i] = Integer.TYPE;
                        continue;
                    }
                    classSig[i] = project.getClassLoader().loadClass(sig[i]);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new SCRDescriptorException("Unable to load class.", e);
                }
            }
        }
        return Validator.getMethod(container.getClassDescription(), name, classSig);
    }

    public static MethodResult findLifecycleMethod(Project project, ComponentContainer container, String methodName, boolean isActivate) throws SCRDescriptorException {
        MethodResult result = new MethodResult();
        result.requiredSpecVersion = SpecVersion.VERSION_1_0;
        result.method = Validator.getMethod(project, container, methodName, new String[]{TYPE_COMPONENT_CONTEXT});
        if (result.method == null) {
            result.requiredSpecVersion = SpecVersion.VERSION_1_1;
            result.method = Validator.getMethod(project, container, methodName, new String[]{TYPE_BUNDLE_CONTEXT});
            if (result.method == null) {
                result.method = Validator.getMethod(project, container, methodName, new String[]{TYPE_MAP});
                if (result.method == null && !isActivate) {
                    result.method = Validator.getMethod(project, container, methodName, new String[]{TYPE_INT});
                    if (result.method == null) {
                        result.method = Validator.getMethod(project, container, methodName, new String[]{TYPE_INTEGER});
                    }
                }
                if (result.method == null) {
                    Method zeroArgMethod = null;
                    Method found = result.method;
                    Method[] methods = container.getClassDescription().getDescribedClass().getDeclaredMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        if (!methodName.equals(methods[i].getName())) continue;
                        if (methods[i].getParameterTypes() == null || methods[i].getParameterTypes().length == 0) {
                            zeroArgMethod = methods[i];
                            continue;
                        }
                        if (methods[i].getParameterTypes().length < 2) continue;
                        boolean valid = true;
                        for (int m = 0; m < methods[i].getParameterTypes().length; ++m) {
                            String type = methods[i].getParameterTypes()[m].getName();
                            if (type.equals(TYPE_BUNDLE_CONTEXT) || type.equals(TYPE_COMPONENT_CONTEXT) || type.equals(TYPE_MAP) || !isActivate && (type.equals(TYPE_INT) || type.equals(TYPE_INTEGER))) continue;
                            valid = false;
                        }
                        if (!valid) continue;
                        if (found == null) {
                            found = methods[i];
                            continue;
                        }
                        result.additionalWarning = "Lifecycle method " + methods[i].getName() + " occurs several times with different matching signature.";
                    }
                    result.method = found != null ? found : zeroArgMethod;
                }
            }
        }
        return result;
    }

    private void checkLifecycleMethod(String methodName, boolean isActivate, boolean isSpecified) throws SCRDescriptorException {
        MethodResult result = Validator.findLifecycleMethod(this.project, this.container, methodName, isActivate);
        if (result.additionalWarning != null) {
            this.logWarn(this.container.getComponentDescription(), result.additionalWarning);
        }
        if (result.method == null) {
            Method[] methods = this.container.getClassDescription().getDescribedClass().getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                String msg;
                if (!methodName.equals(methods[i].getName())) continue;
                if (methods[i].getParameterTypes() == null || methods[i].getParameterTypes().length != 1) {
                    msg = "Lifecycle method " + methods[i].getName() + " has wrong number of arguments";
                    if (isSpecified) {
                        this.logError(this.container.getComponentDescription(), msg);
                        continue;
                    }
                    this.logWarn(this.container.getComponentDescription(), msg);
                    continue;
                }
                msg = "Lifecycle method " + methods[i].getName() + " has wrong argument " + methods[i].getParameterTypes()[0].getName();
                if (isSpecified) {
                    this.logError(this.container.getComponentDescription(), msg);
                    continue;
                }
                this.logWarn(this.container.getComponentDescription(), msg);
            }
        }
        if (result.method != null && this.options.getSpecVersion() == SpecVersion.VERSION_1_0) {
            if (Modifier.isPublic(result.method.getModifiers())) {
                this.logWarn(this.container.getComponentDescription(), "Lifecycle method " + result.method.getName() + " should be declared protected");
            } else if (!Modifier.isProtected(result.method.getModifiers())) {
                this.logWarn(this.container.getComponentDescription(), "Lifecycle method " + result.method.getName() + " has wrong qualifier, public or protected required");
            }
        }
    }

    private void validateService(ServiceDescription service) throws SCRDescriptorException {
        for (String interfaceName : service.getInterfaces()) {
            if (this.container.getClassDescription().getDescribedClass().isInterface()) {
                this.logError(service, "Must be declared in a Java class - not an interface");
                continue;
            }
            try {
                Class<?> interfaceClass = this.project.getClassLoader().loadClass(interfaceName);
                if (interfaceClass.isAssignableFrom(this.container.getClassDescription().getDescribedClass())) continue;
                this.logError(service, "Class must implement provided interface " + interfaceName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new SCRDescriptorException("Unable to load interface class.", cnfe);
            }
        }
    }

    private void validateProperty(PropertyDescription property) {
        if (property.getName() == null || property.getName().trim().length() == 0) {
            this.logError(property, "Property name can not be empty.");
        }
        if (property.getType() != null) {
            if (this.options.getSpecVersion() == SpecVersion.VERSION_1_0 && property.getType() == PropertyType.Character) {
                property.setType(PropertyType.Char);
            }
            if (this.options.getSpecVersion().ordinal() >= SpecVersion.VERSION_1_1.ordinal() && property.getType() == PropertyType.Char) {
                property.setType(PropertyType.Character);
            }
            if (property.getType() == PropertyType.Char || property.getType() == PropertyType.Character) {
                if (property.getValue() != null && property.getValue().length() != 1) {
                    this.logError(property, "Value is not a character: " + property.getValue());
                }
                if (property.getMultiValue() != null) {
                    for (String value : property.getMultiValue()) {
                        if (value.length() == 1) continue;
                        this.logError(property, "Value is not a character: " + value);
                    }
                }
            }
        }
    }

    private void validateReference(ReferenceDescription ref, boolean componentIsAbstract) throws SCRDescriptorException {
        int currentIssueCount = this.iLog.getNumberOfErrors();
        if (StringUtils.isEmpty(ref.getName()) && this.options.getSpecVersion().ordinal() < SpecVersion.VERSION_1_1.ordinal()) {
            this.logError(ref, "Reference has no name");
        }
        if (StringUtils.isEmpty(ref.getInterfaceName())) {
            this.logError(ref, "Missing interface name");
        } else {
            try {
                this.project.getClassLoader().loadClass(ref.getInterfaceName());
            }
            catch (ClassNotFoundException e) {
                this.logError(ref, "Interface class can't be loaded: " + ref.getInterfaceName());
            }
        }
        if (ref.getCardinality() == null) {
            ref.setCardinality(ReferenceCardinality.MANDATORY_UNARY);
        }
        if (ref.getPolicy() == null) {
            ref.setPolicy(ReferencePolicy.STATIC);
        }
        if (ref.getPolicyOption() == null) {
            ref.setPolicyOption(ReferencePolicyOption.RELUCTANT);
        }
        if (ref.getPolicyOption() != ReferencePolicyOption.RELUCTANT && this.options.getSpecVersion().ordinal() < SpecVersion.VERSION_1_2.ordinal()) {
            this.logError(ref, "ReferencePolicyOption " + ref.getPolicyOption().name() + " requires spec version " + SpecVersion.VERSION_1_2.getName() + " or higher.");
        }
        if (ref.getStrategy() == null) {
            ref.setStrategy(ReferenceStrategy.EVENT);
        }
        if (!StringUtils.isEmpty(ref.getInterfaceName())) {
            if (ref.getStrategy() != ReferenceStrategy.LOOKUP) {
                boolean canGenerate;
                String bindName = ref.getBind();
                Object unbindName = ref.getUnbind();
                boolean bl = canGenerate = this.options.isGenerateAccessors() && ref.getField() != null && (ref.getCardinality() == ReferenceCardinality.OPTIONAL_UNARY || ref.getCardinality() == ReferenceCardinality.MANDATORY_UNARY);
                if (bindName == null && !canGenerate) {
                    bindName = "bind";
                }
                if (unbindName == null && !canGenerate) {
                    unbindName = "unbind";
                }
                if (bindName != null) {
                    if ((bindName = this.validateMethod(ref, bindName, componentIsAbstract)) == null && ref.getField() != null) {
                        this.logError(ref, "Something went wrong: " + canGenerate + " - " + this.options.isGenerateAccessors() + " - " + (Object)((Object)ref.getCardinality()));
                    }
                } else {
                    bindName = "bind" + Character.toUpperCase(ref.getName().charAt(0)) + ref.getName().substring(1);
                }
                unbindName = unbindName != null ? ("-".equals(unbindName) ? null : this.validateMethod(ref, (String)unbindName, componentIsAbstract)) : "unbind" + Character.toUpperCase(ref.getName().charAt(0)) + ref.getName().substring(1);
                if (!(this.options.isSkipVolatileCheck() || ref.getField() == null || ref.getCardinality() != ReferenceCardinality.OPTIONAL_UNARY && ref.getCardinality() != ReferenceCardinality.MANDATORY_UNARY || ref.getPolicy() != ReferencePolicy.DYNAMIC)) {
                    boolean fieldIsVolatile = Modifier.isVolatile(ref.getField().getModifiers());
                    if ((ref.isBindMethodCreated() || ref.isUnbindMethodCreated()) && !fieldIsVolatile) {
                        this.logError(ref, "Dynamic field must be declared volatile for unary references");
                    }
                }
                if (this.iLog.getNumberOfErrors() == currentIssueCount) {
                    ref.setBind(bindName);
                    ref.setUnbind((String)unbindName);
                }
            } else {
                ref.setBind(null);
                ref.setUnbind(null);
            }
            if (ref.getUpdated() != null) {
                if (this.options.getSpecVersion().ordinal() < SpecVersion.VERSION_1_1_FELIX.ordinal()) {
                    this.logError(ref, "Updated method declaration requires version " + SpecVersion.VERSION_1_1_FELIX.getName() + ", " + SpecVersion.VERSION_1_2.getName() + " or newer");
                }
                this.validateMethod(ref, ref.getUpdated(), componentIsAbstract);
            }
        }
    }

    private String validateMethod(ReferenceDescription ref, String methodName, boolean componentIsAbstract) throws SCRDescriptorException {
        MethodResult result = Validator.findMethod(this.project, this.options, this.container.getClassDescription(), ref, methodName);
        if (result == null) {
            if (!componentIsAbstract) {
                this.logError(ref, "Missing method " + methodName + " for reference " + (ref.getName() == null ? "" : ref.getName()));
            }
            return null;
        }
        if (this.options.getSpecVersion() == SpecVersion.VERSION_1_0) {
            if (Modifier.isPublic(result.method.getModifiers())) {
                this.logWarn(ref, "Method " + result.method.getName() + " should be declared protected");
            } else if (!Modifier.isProtected(result.method.getModifiers())) {
                this.logError(ref, "Method " + result.method.getName() + " has wrong qualifier, public or protected required");
                return null;
            }
        }
        if (this.options.getSpecVersion().ordinal() < result.requiredSpecVersion.ordinal()) {
            this.logError(ref, "Method declaration for '" + result.method.getName() + "' requires version " + (Object)((Object)result.requiredSpecVersion) + " or newer");
        }
        return result.method.getName();
    }

    private static Method getMethod(ClassDescription cd, String name, Class<?>[] sig) {
        for (Class<?> checkClass = cd.getDescribedClass(); checkClass != null; checkClass = checkClass.getSuperclass()) {
            try {
                return checkClass.getDeclaredMethod(name, sig);
            }
            catch (SecurityException securityException) {
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    public static MethodResult findMethod(Project project, Options options, ClassDescription cd, ReferenceDescription ref, String methodName) throws SCRDescriptorException {
        if ("-".equals(methodName)) {
            return null;
        }
        SpecVersion requiredVersion = SpecVersion.VERSION_1_0;
        try {
            Class[] sig = new Class[]{project.getClassLoader().loadClass(TYPE_SERVICE_REFERENCE)};
            Class[] sig2 = new Class[]{project.getClassLoader().loadClass(ref.getInterfaceName())};
            Class[] sig3 = new Class[]{project.getClassLoader().loadClass(ref.getInterfaceName()), Map.class};
            String realMethodName = methodName;
            Method method = Validator.getMethod(cd, realMethodName, sig);
            if (method == null && (method = Validator.getMethod(cd, realMethodName, sig2)) == null && (options.getSpecVersion() == null || options.getSpecVersion().ordinal() >= SpecVersion.VERSION_1_1.ordinal())) {
                method = Validator.getMethod(cd, realMethodName, sig3);
                requiredVersion = SpecVersion.VERSION_1_1;
            }
            if (method == null) {
                String info;
                if (StringUtils.isEmpty(ref.getName())) {
                    String interfaceName = ref.getInterfaceName();
                    int pos = interfaceName.lastIndexOf(46);
                    info = interfaceName.substring(pos + 1);
                } else {
                    info = ref.getName();
                }
                realMethodName = methodName + Character.toUpperCase(info.charAt(0)) + info.substring(1);
                method = Validator.getMethod(cd, realMethodName, sig);
            }
            if (method == null && (method = Validator.getMethod(cd, realMethodName, sig2)) == null && (options.getSpecVersion() == null || options.getSpecVersion().ordinal() >= SpecVersion.VERSION_1_1.ordinal())) {
                method = Validator.getMethod(cd, realMethodName, sig3);
                requiredVersion = SpecVersion.VERSION_1_1;
            }
            if (method == null) {
                int lastDot = ref.getInterfaceName().lastIndexOf(46);
                realMethodName = methodName + ref.getInterfaceName().substring(lastDot + 1);
                method = Validator.getMethod(cd, realMethodName, sig);
            }
            if (method == null && (method = Validator.getMethod(cd, realMethodName, sig2)) == null && (options.getSpecVersion() == null || options.getSpecVersion().ordinal() >= SpecVersion.VERSION_1_1.ordinal())) {
                method = Validator.getMethod(cd, realMethodName, sig3);
                requiredVersion = SpecVersion.VERSION_1_1;
            }
            if (method == null) {
                return null;
            }
            MethodResult result = new MethodResult();
            result.method = method;
            result.requiredSpecVersion = requiredVersion;
            return result;
        }
        catch (ClassNotFoundException cnfe) {
            throw new SCRDescriptorException("Unable to load class!", cnfe);
        }
    }

    public static final class MethodResult {
        public Method method;
        public SpecVersion requiredSpecVersion;
        public String additionalWarning;
    }
}

