/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.adhocquery.api;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.adhocquery.data.AdHocData;
import org.apache.fineract.adhocquery.data.AdHocRequest;
import org.apache.fineract.adhocquery.service.AdHocReadPlatformService;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.stereotype.Component;

@Path(value="/v1/adhocquery")
@Component
@Tag(name="AdhocQuery Api", description="")
public class AdHocApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "name", "query", "tableName", "tableField", "isActive", "createdBy", "createdOn", "createdById", "updatedById", "updatedOn", "email"));
    private final PlatformSecurityContext context;
    private final AdHocReadPlatformService adHocReadPlatformService;
    private final DefaultToApiJsonSerializer<AdHocData> toApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<AdHocData> retrieveAll() {
        this.context.authenticatedUser();
        return this.adHocReadPlatformService.retrieveAllAdHocQuery();
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="template")
    public AdHocData template() {
        this.context.authenticatedUser();
        return this.adHocReadPlatformService.retrieveNewAdHocDetails();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CommandProcessingResult createAdHocQuery(AdHocRequest adHocRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createAdHoc().withJson(this.toApiJsonSerializer.serialize((Object)adHocRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @GET
    @Path(value="{adHocId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public AdHocData retrieveAdHocQuery(@PathParam(value="adHocId") @Parameter(description="adHocId") Long adHocId) {
        this.context.authenticatedUser();
        return this.adHocReadPlatformService.retrieveOne(adHocId);
    }

    @PUT
    @Path(value="{adHocId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CommandProcessingResult update(@PathParam(value="adHocId") @Parameter(description="adHocId") Long adHocId, AdHocRequest adHocRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateAdHoc(adHocId).withJson(this.toApiJsonSerializer.serialize((Object)adHocRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @DELETE
    @Path(value="{adHocId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CommandProcessingResult deleteAdHocQuery(@PathParam(value="adHocId") @Parameter(description="adHocId") Long adHocId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteAdHoc(adHocId).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @Generated
    public AdHocApiResource(PlatformSecurityContext context, AdHocReadPlatformService adHocReadPlatformService, DefaultToApiJsonSerializer<AdHocData> toApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.adHocReadPlatformService = adHocReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

