/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.adhocquery.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.adhocquery.api.AdHocJsonInputParams;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractAuditableCustom;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_adhoc")
public class AdHoc
extends AbstractAuditableCustom
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Column(name="name", length=100)
    private String name;
    @Column(name="query", length=2000)
    private String query;
    @Column(name="table_name", length=100)
    private String tableName;
    @Column(name="table_fields", length=2000)
    private String tableFields;
    @Column(name="email", length=500)
    private String email;
    @Column(name="report_run_frequency_code")
    private Long reportRunFrequency;
    @Column(name="report_run_every")
    private Long reportRunEvery;
    @Column(name="is_active", nullable=false)
    private boolean active;
    static final long serialVersionUID = 4055548113575473896L;

    public static AdHoc fromJson(JsonCommand command) {
        String name = command.stringValueOfParameterNamed(AdHocJsonInputParams.NAME.getValue());
        String query = command.stringValueOfParameterNamed(AdHocJsonInputParams.QUERY.getValue());
        String tableName = command.stringValueOfParameterNamed(AdHocJsonInputParams.TABLENAME.getValue());
        String tableFields = command.stringValueOfParameterNamed(AdHocJsonInputParams.TABLEFIELDS.getValue());
        String email = command.stringValueOfParameterNamed(AdHocJsonInputParams.EMAIL.getValue());
        Long reportRunFrequency = command.longValueOfParameterNamed(AdHocJsonInputParams.REPORT_RUN_FREQUENCY.getValue());
        Long reportRunEvery = command.longValueOfParameterNamed(AdHocJsonInputParams.REPORT_RUN_EVERY.getValue());
        boolean active = command.booleanPrimitiveValueOfParameterNamed(AdHocJsonInputParams.ACTIVE.getValue());
        return new AdHoc().setName((String)StringUtils.defaultIfEmpty((CharSequence)name, null)).setQuery((String)StringUtils.defaultIfEmpty((CharSequence)query, null)).setTableName((String)StringUtils.defaultIfEmpty((CharSequence)tableName, null)).setTableFields((String)StringUtils.defaultIfEmpty((CharSequence)tableFields, null)).setEmail((String)StringUtils.defaultIfEmpty((CharSequence)email, null)).setReportRunFrequency(reportRunFrequency).setReportRunEvery(reportRunEvery).setActive(false);
    }

    public Map<String, Object> update(JsonCommand command) {
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(7);
        String nameParamName = "name";
        if (command.isChangeInStringParameterNamed("name", this._persistence_get_name())) {
            String newValue = command.stringValueOfParameterNamed("name");
            actualChanges.put("name", newValue);
            this._persistence_set_name(newValue);
        }
        String descriptionParamName = "query";
        if (command.isChangeInStringParameterNamed("query", this._persistence_get_query())) {
            String newValue = command.stringValueOfParameterNamed("query");
            actualChanges.put("query", newValue);
            this._persistence_set_query(newValue);
        }
        String tableName = "tableName";
        if (command.isChangeInStringParameterNamed("tableName", this._persistence_get_tableName())) {
            String newValue = command.stringValueOfParameterNamed("tableName");
            actualChanges.put("tableName", newValue);
            this._persistence_set_tableName(newValue);
        }
        String tableField = "tableFields";
        if (command.isChangeInStringParameterNamed("tableFields", this._persistence_get_tableFields())) {
            String newValue = command.stringValueOfParameterNamed("tableFields");
            actualChanges.put("tableFields", newValue);
            this._persistence_set_tableFields(newValue);
        }
        String email = "email";
        if (command.isChangeInStringParameterNamed("email", this._persistence_get_email())) {
            String newValue = command.stringValueOfParameterNamed("email");
            actualChanges.put("email", newValue);
            this._persistence_set_email(newValue);
        }
        String reportRunFrequency = "reportRunFrequency";
        if (command.isChangeInLongParameterNamed("reportRunFrequency", this.getReportRunFrequency())) {
            Long newValue = command.longValueOfParameterNamed("reportRunFrequency");
            actualChanges.put("reportRunFrequency", newValue);
            this._persistence_set_reportRunFrequency(newValue);
        }
        String reportRunEvery = "reportRunEvery";
        if (command.isChangeInLongParameterNamed("reportRunEvery", this.getReportRunEvery())) {
            Long newValue = command.longValueOfParameterNamed("reportRunEvery");
            actualChanges.put("reportRunEvery", newValue);
            this._persistence_set_reportRunEvery(newValue);
        }
        String paramisActive = "active";
        if (command.isChangeInBooleanParameterNamed("active", Boolean.valueOf(this._persistence_get_active()))) {
            Boolean newValue = command.booleanObjectValueOfParameterNamed("active");
            actualChanges.put("active", newValue);
            this._persistence_set_active(newValue.booleanValue());
        }
        return actualChanges;
    }

    @Generated
    public String getName() {
        return this._persistence_get_name();
    }

    @Generated
    public String getQuery() {
        return this._persistence_get_query();
    }

    @Generated
    public String getTableName() {
        return this._persistence_get_tableName();
    }

    @Generated
    public String getTableFields() {
        return this._persistence_get_tableFields();
    }

    @Generated
    public String getEmail() {
        return this._persistence_get_email();
    }

    @Generated
    public Long getReportRunFrequency() {
        return this._persistence_get_reportRunFrequency();
    }

    @Generated
    public Long getReportRunEvery() {
        return this._persistence_get_reportRunEvery();
    }

    @Generated
    public boolean isActive() {
        return this._persistence_get_active();
    }

    @Generated
    public AdHoc setName(String name) {
        this._persistence_set_name(name);
        return this;
    }

    @Generated
    public AdHoc setQuery(String query) {
        this._persistence_set_query(query);
        return this;
    }

    @Generated
    public AdHoc setTableName(String tableName) {
        this._persistence_set_tableName(tableName);
        return this;
    }

    @Generated
    public AdHoc setTableFields(String tableFields) {
        this._persistence_set_tableFields(tableFields);
        return this;
    }

    @Generated
    public AdHoc setEmail(String email) {
        this._persistence_set_email(email);
        return this;
    }

    @Generated
    public AdHoc setReportRunFrequency(Long reportRunFrequency) {
        this._persistence_set_reportRunFrequency(reportRunFrequency);
        return this;
    }

    @Generated
    public AdHoc setReportRunEvery(Long reportRunEvery) {
        this._persistence_set_reportRunEvery(reportRunEvery);
        return this;
    }

    @Generated
    public AdHoc setActive(boolean active) {
        this._persistence_set_active(active);
        return this;
    }

    @Generated
    public AdHoc() {
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AdHoc(persistenceObject);
    }

    public AdHoc(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "tableFields") {
            return this.tableFields;
        }
        if (string == "query") {
            return this.query;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "tableName") {
            return this.tableName;
        }
        if (string == "reportRunFrequency") {
            return this.reportRunFrequency;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "reportRunEvery") {
            return this.reportRunEvery;
        }
        if (string == "email") {
            return this.email;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "tableFields") {
            this.tableFields = (String)object;
            return;
        }
        if (string == "query") {
            this.query = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "tableName") {
            this.tableName = (String)object;
            return;
        }
        if (string == "reportRunFrequency") {
            this.reportRunFrequency = (Long)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "reportRunEvery") {
            this.reportRunEvery = (Long)object;
            return;
        }
        if (string == "email") {
            this.email = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_tableFields() {
        this._persistence_checkFetched("tableFields");
        return this.tableFields;
    }

    public void _persistence_set_tableFields(String string) {
        this._persistence_checkFetchedForSet("tableFields");
        this._persistence_propertyChange("tableFields", (Object)this.tableFields, (Object)string);
        this.tableFields = string;
    }

    public String _persistence_get_query() {
        this._persistence_checkFetched("query");
        return this.query;
    }

    public void _persistence_set_query(String string) {
        this._persistence_checkFetchedForSet("query");
        this._persistence_propertyChange("query", (Object)this.query, (Object)string);
        this.query = string;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", (Object)new Boolean(this.active), (Object)new Boolean(bl));
        this.active = bl;
    }

    public String _persistence_get_tableName() {
        this._persistence_checkFetched("tableName");
        return this.tableName;
    }

    public void _persistence_set_tableName(String string) {
        this._persistence_checkFetchedForSet("tableName");
        this._persistence_propertyChange("tableName", (Object)this.tableName, (Object)string);
        this.tableName = string;
    }

    public Long _persistence_get_reportRunFrequency() {
        this._persistence_checkFetched("reportRunFrequency");
        return this.reportRunFrequency;
    }

    public void _persistence_set_reportRunFrequency(Long l) {
        this._persistence_checkFetchedForSet("reportRunFrequency");
        this._persistence_propertyChange("reportRunFrequency", (Object)this.reportRunFrequency, (Object)l);
        this.reportRunFrequency = l;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this._persistence_propertyChange("name", (Object)this.name, (Object)string);
        this.name = string;
    }

    public Long _persistence_get_reportRunEvery() {
        this._persistence_checkFetched("reportRunEvery");
        return this.reportRunEvery;
    }

    public void _persistence_set_reportRunEvery(Long l) {
        this._persistence_checkFetchedForSet("reportRunEvery");
        this._persistence_propertyChange("reportRunEvery", (Object)this.reportRunEvery, (Object)l);
        this.reportRunEvery = l;
    }

    public String _persistence_get_email() {
        this._persistence_checkFetched("email");
        return this.email;
    }

    public void _persistence_set_email(String string) {
        this._persistence_checkFetchedForSet("email");
        this._persistence_propertyChange("email", (Object)this.email, (Object)string);
        this.email = string;
    }
}

