/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.event.external.service.serialization.serializer.savings;

import lombok.Generated;
import org.apache.avro.generic.GenericContainer;
import org.apache.fineract.avro.generator.ByteBufferSerializable;
import org.apache.fineract.avro.savings.v1.SavingsAccountTransactionDataV1;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.savings.transaction.SavingsAccountTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.savings.SavingsAccountTransactionDataMapper;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.BusinessEventSerializer;
import org.apache.fineract.portfolio.savings.data.SavingsAccountTransactionData;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransaction;
import org.apache.fineract.portfolio.savings.service.SavingsAccountReadPlatformService;
import org.springframework.stereotype.Component;

@Component
public class SavingsAccountTransactionBusinessEventSerializer
implements BusinessEventSerializer {
    private final SavingsAccountReadPlatformService service;
    private final SavingsAccountTransactionDataMapper mapper;

    public <T> boolean canSerialize(BusinessEvent<T> event) {
        return event instanceof SavingsAccountTransactionBusinessEvent;
    }

    public <T> ByteBufferSerializable toAvroDTO(BusinessEvent<T> rawEvent) {
        SavingsAccountTransactionBusinessEvent event = (SavingsAccountTransactionBusinessEvent)rawEvent;
        SavingsAccountTransaction tx = (SavingsAccountTransaction)event.get();
        SavingsAccountTransactionData data = this.service.retrieveSavingsTransaction((Long)tx.getSavingsAccount().getId(), (Long)tx.getId(), tx.getSavingsAccount().depositAccountType());
        return this.mapper.map(data);
    }

    public Class<? extends GenericContainer> getSupportedSchema() {
        return SavingsAccountTransactionDataV1.class;
    }

    @Generated
    public SavingsAccountTransactionBusinessEventSerializer(SavingsAccountReadPlatformService service, SavingsAccountTransactionDataMapper mapper) {
        this.service = service;
        this.mapper = mapper;
    }
}

