/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.jobs.data.JobParameterDTO;
import org.springframework.stereotype.Component;

@Component
public class JobParameterDataParser {
    private final FromJsonHelper jsonHelper;

    public Set<JobParameterDTO> parseExecution(String requestBody) {
        if (StringUtils.isBlank((CharSequence)requestBody)) {
            return Collections.emptySet();
        }
        JsonObject element = JsonParser.parseString((String)requestBody).getAsJsonObject();
        if (Objects.isNull(element)) {
            return Collections.emptySet();
        }
        JsonArray jobParametersJsonArray = this.jsonHelper.extractJsonArrayNamed("jobParameters", (JsonElement)element);
        if (Objects.isNull(jobParametersJsonArray)) {
            return Collections.emptySet();
        }
        HashSet<JobParameterDTO> jobParameters = new HashSet<JobParameterDTO>();
        for (JsonElement jobParameterElement : jobParametersJsonArray) {
            jobParameters.add(new JobParameterDTO(jobParameterElement.getAsJsonObject().get("parameterName").getAsString(), jobParameterElement.getAsJsonObject().get("parameterValue").getAsString()));
        }
        return Collections.unmodifiableSet(jobParameters);
    }

    @Generated
    public JobParameterDataParser(FromJsonHelper jsonHelper) {
        this.jsonHelper = jsonHelper;
    }
}

