/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.data;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.security.constants.TwoFactorConfigurationConstants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"fineract.security.2fa.enabled"})
public class TwoFactorConfigurationValidator {
    private final FromJsonHelper fromJsonHelper;

    @Autowired
    public TwoFactorConfigurationValidator(FromJsonHelper fromJsonHelper) {
        this.fromJsonHelper = fromJsonHelper;
    }

    public void validateForUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        boolean atLeastOneParameterPassedForUpdate = false;
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)TwoFactorConfigurationConstants.REQUEST_DATA_PARAMETERS);
        JsonElement element = this.fromJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("TWOFACTOR_CONFIGURATION");
        for (String parameterName : TwoFactorConfigurationConstants.BOOLEAN_PARAMETERS) {
            if (!this.fromJsonHelper.parameterExists(parameterName, element)) continue;
            atLeastOneParameterPassedForUpdate = true;
            this.validateBooleanParameter(parameterName, element, baseDataValidator);
        }
        for (String parameterName : TwoFactorConfigurationConstants.STRING_PARAMETERS) {
            if (!this.fromJsonHelper.parameterExists(parameterName, element)) continue;
            atLeastOneParameterPassedForUpdate = true;
            this.validateStringParameter(parameterName, element, baseDataValidator);
        }
        for (String parameterName : TwoFactorConfigurationConstants.NUMBER_PARAMETERS) {
            if (!this.fromJsonHelper.parameterExists(parameterName, element)) continue;
            atLeastOneParameterPassedForUpdate = true;
            this.validateNumberParameter(parameterName, element, baseDataValidator);
        }
        if (!atLeastOneParameterPassedForUpdate) {
            Object forceError = null;
            baseDataValidator.reset().anyOfNotNull(new Object[]{forceError});
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    private void validateBooleanParameter(String name, JsonElement element, DataValidatorBuilder baseDataValidator) {
        String value = this.fromJsonHelper.extractStringNamed(name, element);
        baseDataValidator.reset().parameter(name).value((Object)value).notNull().trueOrFalseRequired((Object)value);
    }

    private void validateStringParameter(String name, JsonElement element, DataValidatorBuilder baseDataValidator) {
        String value = this.fromJsonHelper.extractStringNamed(name, element);
        baseDataValidator.reset().parameter(name).value((Object)value).notBlank().notExceedingLengthOf(Integer.valueOf(1000));
    }

    private void validateNumberParameter(String name, JsonElement element, DataValidatorBuilder baseDataValidator) {
        Integer value = this.fromJsonHelper.extractIntegerSansLocaleNamed(name, element);
        baseDataValidator.reset().parameter(name).value((Object)value).notNull().integerGreaterThanZero();
    }
}

