/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.springbatch.messagehandler.jms;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.MessageListener;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.springbatch.messagehandler.conditions.jms.JmsWorkerCondition;
import org.apache.fineract.infrastructure.springbatch.messagehandler.jms.JmsBatchWorkerMessageListener;
import org.apache.fineract.infrastructure.springbatch.messagehandler.jms.JmsBrokerConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpoint;
import org.springframework.jms.config.SimpleJmsListenerEndpoint;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

@Configuration(proxyBeanMethods=false)
@Conditional(value={JmsWorkerCondition.class})
@Import(value={JmsBrokerConfiguration.class})
public class JmsWorkerConfig {
    @Autowired
    private FineractProperties fineractProperties;

    @Bean
    public DefaultJmsListenerContainerFactory jmsBatchWorkerListenerContainerFactory(ConnectionFactory connectionFactory) {
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        factory.setConcurrency("1-1");
        factory.setConnectionFactory(connectionFactory);
        factory.setPubSubDomain(Boolean.valueOf(false));
        factory.setSessionTransacted(Boolean.valueOf(false));
        factory.setSessionAcknowledgeMode(Integer.valueOf(2));
        return factory;
    }

    @Bean
    public DefaultMessageListenerContainer jmsBatchWorkerMessageListenerContainer(@Qualifier(value="jmsBatchWorkerListenerContainerFactory") DefaultJmsListenerContainerFactory factory, JmsBatchWorkerMessageListener messageListener) {
        SimpleJmsListenerEndpoint endpoint = new SimpleJmsListenerEndpoint();
        endpoint.setDestination(this.fineractProperties.getRemoteJobMessageHandler().getJms().getRequestQueueName());
        endpoint.setMessageListener((MessageListener)messageListener);
        return (DefaultMessageListenerContainer)factory.createListenerContainer((JmsListenerEndpoint)endpoint);
    }
}

