/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.survey.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.survey.data.LikelihoodData;
import org.apache.fineract.infrastructure.survey.service.ReadLikelihoodService;
import org.springframework.stereotype.Component;

@Path(value="/v1/likelihood")
@Component
@Tag(name="Likelihood", description="")
public class LikelihoodApiResource {
    private final DefaultToApiJsonSerializer<LikelihoodData> toApiJsonSerializer;
    private final PlatformSecurityContext context;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final ReadLikelihoodService readService;

    @GET
    @Path(value="{ppiName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveAll(@PathParam(value="ppiName") String ppiName) {
        this.context.authenticatedUser().validateHasReadPermission("PovertyLine");
        List likelihoodData = this.readService.retrieveAll(ppiName);
        return this.toApiJsonSerializer.serialize((Object)likelihoodData);
    }

    @GET
    @Path(value="{ppiName}/{likelihoodId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieve(@PathParam(value="likelihoodId") Long likelihoodId, @PathParam(value="ppiName") String ppiName) {
        this.context.authenticatedUser().validateHasReadPermission("PovertyLine");
        LikelihoodData likelihoodData = this.readService.retrieve(likelihoodId);
        return this.toApiJsonSerializer.serialize((Object)likelihoodData);
    }

    @PUT
    @Path(value="{ppiName}/{likelihoodId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String update(@PathParam(value="likelihoodId") Long likelihoodId, String apiRequestBodyAsJson, @PathParam(value="ppiName") String ppiName) {
        this.context.authenticatedUser().validateHasReadPermission("PovertyLine");
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateLikelihood(likelihoodId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public LikelihoodApiResource(DefaultToApiJsonSerializer<LikelihoodData> toApiJsonSerializer, PlatformSecurityContext context, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, ReadLikelihoodService readService) {
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.context = context;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.readService = readService;
    }
}

