/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collateral.command;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.portfolio.collateral.api.CollateralApiConstants;

public class CollateralCommand {
    private final Long collateralTypeId;
    private final BigDecimal value;
    private final String description;

    public CollateralCommand(Long collateralTypeId, BigDecimal value, String description) {
        this.collateralTypeId = collateralTypeId;
        this.value = value;
        this.description = description;
    }

    public Long getCollateralTypeId() {
        return this.collateralTypeId;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public void validateForCreate() {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("collateral");
        baseDataValidator.reset().parameter(CollateralApiConstants.CollateralJSONinputParams.COLLATERAL_TYPE_ID.getValue()).value((Object)this.collateralTypeId).notNull().integerGreaterThanZero();
        baseDataValidator.reset().parameter(CollateralApiConstants.CollateralJSONinputParams.VALUE.getValue()).value((Object)this.value).ignoreIfNull().positiveAmount();
        baseDataValidator.reset().parameter(CollateralApiConstants.CollateralJSONinputParams.DESCRIPTION.getValue()).value((Object)this.description).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(500));
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }

    public void validateForUpdate() {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("collateral");
        baseDataValidator.reset().parameter(CollateralApiConstants.CollateralJSONinputParams.COLLATERAL_TYPE_ID.getValue()).value((Object)this.collateralTypeId).ignoreIfNull().integerGreaterThanZero();
        baseDataValidator.reset().parameter(CollateralApiConstants.CollateralJSONinputParams.VALUE.getValue()).value((Object)this.value).ignoreIfNull().positiveAmount();
        baseDataValidator.reset().parameter(CollateralApiConstants.CollateralJSONinputParams.DESCRIPTION.getValue()).value((Object)this.description).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(500));
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }
}

