/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.rate.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.rate.domain.Rate;
import org.apache.fineract.portfolio.rate.domain.RateRepositoryWrapper;

public class RateAssembler {
    private final FromJsonHelper fromApiJsonHelper;
    private final RateRepositoryWrapper rateRepository;

    public List<Rate> fromParsedJson(JsonElement element) {
        JsonObject topLevelJsonElement;
        ArrayList<Rate> rateItems = new ArrayList<Rate>();
        if (element.isJsonObject() && (topLevelJsonElement = element.getAsJsonObject()).has("rates") && topLevelJsonElement.get("rates").isJsonArray()) {
            JsonArray array = topLevelJsonElement.get("rates").getAsJsonArray();
            ArrayList<Long> idList = new ArrayList<Long>();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject rateElement = array.get(i).getAsJsonObject();
                Long id = this.fromApiJsonHelper.extractLongNamed("id", (JsonElement)rateElement);
                if (id == null) continue;
                Long rateId = this.fromApiJsonHelper.extractLongNamed("id", (JsonElement)rateElement);
                idList.add(rateId);
            }
            rateItems.addAll(this.rateRepository.findMultipleWithNotFoundDetection(idList));
        }
        return rateItems;
    }

    @Generated
    public RateAssembler(FromJsonHelper fromApiJsonHelper, RateRepositoryWrapper rateRepository) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.rateRepository = rateRepository;
    }
}

