/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.service;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.interestratechart.service.InterestIncentiveDropdownReadPlatformService;
import org.apache.fineract.portfolio.interestratechart.service.InterestRateChartDropdownReadPlatformService;
import org.apache.fineract.portfolio.savings.data.DepositAccountInterestRateChartData;
import org.apache.fineract.portfolio.savings.exception.DepositAccountInterestRateChartNotFoundException;
import org.apache.fineract.portfolio.savings.service.DepositAccountInterestRateChartReadPlatformService;
import org.apache.fineract.portfolio.savings.service.DepositAccountInterestRateChartReadPlatformServiceImpl;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;

public class DepositAccountInterestRateChartReadPlatformServiceImpl
implements DepositAccountInterestRateChartReadPlatformService {
    private final PlatformSecurityContext context;
    private final JdbcTemplate jdbcTemplate;
    private static final DepositAccountInterestRateChartMapper CHART_ROW_MAPPER = new DepositAccountInterestRateChartMapper();
    private final DepositAccountInterestRateChartExtractor chartExtractor;
    private final InterestRateChartDropdownReadPlatformService chartDropdownReadPlatformService;
    private final InterestIncentiveDropdownReadPlatformService interestIncentiveDropdownReadPlatformService;
    private final CodeValueReadPlatformService codeValueReadPlatformService;

    public DepositAccountInterestRateChartData retrieveOne(Long chartId) {
        try {
            this.context.authenticatedUser();
            String sql = "select " + CHART_ROW_MAPPER.schema() + " where irc.id = ? ";
            return (DepositAccountInterestRateChartData)this.jdbcTemplate.queryForObject(sql, (RowMapper)CHART_ROW_MAPPER, new Object[]{chartId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new DepositAccountInterestRateChartNotFoundException(chartId, e);
        }
    }

    public DepositAccountInterestRateChartData retrieveOneWithSlabs(Long chartId) {
        this.context.authenticatedUser();
        StringBuilder sql = new StringBuilder();
        sql.append("select ");
        sql.append(this.chartExtractor.schema());
        sql.append(" where irc.id = ? order by irc.id asc, ");
        sql.append("CASE ");
        sql.append("WHEN irc.is_primary_grouping_by_amount then ircd.amount_range_from ");
        sql.append("WHEN irc.is_primary_grouping_by_amount then ircd.amount_range_to ");
        sql.append("END,");
        sql.append("ircd.from_period, ircd.to_period,");
        sql.append("CASE ");
        sql.append("WHEN NOT irc.is_primary_grouping_by_amount then ircd.amount_range_from ");
        sql.append("WHEN NOT irc.is_primary_grouping_by_amount then ircd.amount_range_to ");
        sql.append("END");
        Collection chartDatas = (Collection)this.jdbcTemplate.query(sql.toString(), (ResultSetExtractor)this.chartExtractor, new Object[]{chartId});
        if (chartDatas == null || chartDatas.isEmpty()) {
            throw new DepositAccountInterestRateChartNotFoundException(chartId);
        }
        return (DepositAccountInterestRateChartData)chartDatas.iterator().next();
    }

    public DepositAccountInterestRateChartData retrieveWithTemplate(DepositAccountInterestRateChartData chartData) {
        ArrayList genderOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("Gender"));
        ArrayList clientTypeOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("ClientType"));
        ArrayList clientClassificationOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("ClientClassification"));
        return DepositAccountInterestRateChartData.withTemplate((DepositAccountInterestRateChartData)chartData, (Collection)this.chartDropdownReadPlatformService.retrievePeriodTypeOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveEntityTypeOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveAttributeNameOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveConditionTypeOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveIncentiveTypeOptions(), genderOptions, clientTypeOptions, clientClassificationOptions);
    }

    public DepositAccountInterestRateChartData retrieveOneWithSlabsOnAccountId(Long accountId) {
        this.context.authenticatedUser();
        StringBuilder sql = new StringBuilder();
        sql.append("select ");
        sql.append(this.chartExtractor.schema());
        sql.append(" where irc.savings_account_id = ? order by irc.id asc, ");
        sql.append("CASE ");
        sql.append("WHEN irc.is_primary_grouping_by_amount then ircd.amount_range_from ");
        sql.append("WHEN irc.is_primary_grouping_by_amount then ircd.amount_range_to ");
        sql.append("END,");
        sql.append("ircd.from_period, ircd.to_period,");
        sql.append("CASE ");
        sql.append("WHEN NOT irc.is_primary_grouping_by_amount then ircd.amount_range_from ");
        sql.append("WHEN NOT irc.is_primary_grouping_by_amount then ircd.amount_range_to ");
        sql.append("END");
        Collection chartDatas = (Collection)this.jdbcTemplate.query(con -> {
            PreparedStatement preparedStatement = con.prepareStatement(sql.toString(), 1005, 1008);
            preparedStatement.setLong(1, accountId);
            return preparedStatement;
        }, (ResultSetExtractor)this.chartExtractor);
        if (chartDatas == null || chartDatas.isEmpty()) {
            throw new DepositAccountInterestRateChartNotFoundException(accountId);
        }
        return (DepositAccountInterestRateChartData)chartDatas.iterator().next();
    }

    public DepositAccountInterestRateChartData template() {
        ArrayList genderOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("Gender"));
        ArrayList clientTypeOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("ClientType"));
        ArrayList clientClassificationOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("ClientClassification"));
        return DepositAccountInterestRateChartData.template((Collection)this.chartDropdownReadPlatformService.retrievePeriodTypeOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveEntityTypeOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveAttributeNameOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveConditionTypeOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveIncentiveTypeOptions(), genderOptions, clientTypeOptions, clientClassificationOptions);
    }

    @Generated
    public DepositAccountInterestRateChartReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate, DepositAccountInterestRateChartExtractor chartExtractor, InterestRateChartDropdownReadPlatformService chartDropdownReadPlatformService, InterestIncentiveDropdownReadPlatformService interestIncentiveDropdownReadPlatformService, CodeValueReadPlatformService codeValueReadPlatformService) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
        this.chartExtractor = chartExtractor;
        this.chartDropdownReadPlatformService = chartDropdownReadPlatformService;
        this.interestIncentiveDropdownReadPlatformService = interestIncentiveDropdownReadPlatformService;
        this.codeValueReadPlatformService = codeValueReadPlatformService;
    }
}

