/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareaccounts.service;

import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountAssembler;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransaction;
import org.apache.fineract.portfolio.savings.service.SavingsAccountDomainService;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountDividendDetails;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountDividendRepository;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountDividendStatusType;
import org.apache.fineract.portfolio.shareaccounts.service.ShareAccountSchedularService;
import org.springframework.transaction.annotation.Transactional;

public class ShareAccountSchedularServiceImpl
implements ShareAccountSchedularService {
    private final ShareAccountDividendRepository shareAccountDividendRepository;
    private final SavingsAccountDomainService savingsAccountDomainService;
    private final SavingsAccountAssembler savingsAccountAssembler;

    @Transactional
    public void postDividend(Long dividendDetailId, Long savingsId) {
        ShareAccountDividendDetails shareAccountDividendDetails = (ShareAccountDividendDetails)this.shareAccountDividendRepository.findById((Object)dividendDetailId).orElseThrow();
        SavingsAccount savingsAccount = this.savingsAccountAssembler.assembleFrom(savingsId, false);
        SavingsAccountTransaction savingsAccountTransaction = this.savingsAccountDomainService.handleDividendPayout(savingsAccount, DateUtils.getBusinessLocalDate(), shareAccountDividendDetails.getAmount(), false);
        shareAccountDividendDetails.update(ShareAccountDividendStatusType.POSTED.getValue(), (Long)savingsAccountTransaction.getId());
        this.shareAccountDividendRepository.saveAndFlush((Object)shareAccountDividendDetails);
    }

    @Generated
    public ShareAccountSchedularServiceImpl(ShareAccountDividendRepository shareAccountDividendRepository, SavingsAccountDomainService savingsAccountDomainService, SavingsAccountAssembler savingsAccountAssembler) {
        this.shareAccountDividendRepository = shareAccountDividendRepository;
        this.savingsAccountDomainService = savingsAccountDomainService;
        this.savingsAccountAssembler = savingsAccountAssembler;
    }
}

