/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.spm.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.spm.data.LookupTableData;
import org.apache.fineract.spm.domain.Survey;
import org.apache.fineract.spm.exception.LookupTableNotFoundException;
import org.apache.fineract.spm.exception.SurveyNotFoundException;
import org.apache.fineract.spm.service.LookupTableService;
import org.apache.fineract.spm.service.SpmService;
import org.apache.fineract.spm.util.LookupTableMapper;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="/v1/surveys/{surveyId}/lookuptables")
@Component
@Tag(name="SPM API - LookUp Table", description="The Apache Fineract SPM API provides the ability to create custom surveys to collect social performance measurentment data or any additional questionnaire a financial institute want to collect.")
public class LookupTableApiResource {
    private final PlatformSecurityContext securityContext;
    private final SpmService spmService;
    private final LookupTableService lookupTableService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Transactional
    @Operation(summary="List all Lookup Table entries", description="List all Lookup Table entries for a survey.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=LookupTableData.class)))})})
    public List<LookupTableData> fetchLookupTables(@PathParam(value="surveyId") @Parameter(description="Enter surveyId") Long surveyId) {
        this.securityContext.authenticatedUser();
        Survey survey = this.findSurvey(surveyId);
        List lookupTables = this.lookupTableService.findBySurvey(survey);
        if (lookupTables != null) {
            return LookupTableMapper.map((List)lookupTables);
        }
        return Collections.emptyList();
    }

    @GET
    @Path(value="/{key}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Transactional
    @Operation(summary="Retrieve a Lookup Table entry", description="Retrieve a Lookup Table entry for a survey.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LookupTableData.class))})})
    public LookupTableData findLookupTable(@PathParam(value="surveyId") @Parameter(description="Enter surveyId") Long surveyId, @PathParam(value="key") @Parameter(description="Enter key") String key) {
        this.securityContext.authenticatedUser();
        this.findSurvey(surveyId);
        List lookupTables = this.lookupTableService.findByKey(key);
        if (lookupTables == null || lookupTables.isEmpty()) {
            throw new LookupTableNotFoundException(key);
        }
        return (LookupTableData)LookupTableMapper.map((List)lookupTables).get(0);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Transactional
    @Operation(summary="Create a Lookup Table entry", description="Add a new entry to a survey.\n\nMandatory Fields\nkey, score, validFrom, validTo")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public void createLookupTable(@PathParam(value="surveyId") @Parameter(description="Enter surveyId") Long surveyId, LookupTableData lookupTableData) {
        this.securityContext.authenticatedUser();
        Survey survey = this.findSurvey(surveyId);
        this.lookupTableService.createLookupTable(LookupTableMapper.map((LookupTableData)lookupTableData, (Survey)survey));
    }

    private Survey findSurvey(Long surveyId) {
        Survey survey = this.spmService.findById(surveyId);
        if (survey == null) {
            throw new SurveyNotFoundException(surveyId);
        }
        return survey;
    }

    @Generated
    public LookupTableApiResource(PlatformSecurityContext securityContext, SpmService spmService, LookupTableService lookupTableService) {
        this.securityContext = securityContext;
        this.spmService = spmService;
        this.lookupTableService = lookupTableService;
    }
}

