/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.useradministration.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.useradministration.data.PasswordPreferencesDataValidator;
import org.apache.fineract.useradministration.domain.PasswordValidationPolicy;
import org.apache.fineract.useradministration.domain.PasswordValidationPolicyRepository;
import org.apache.fineract.useradministration.exception.PasswordValidationPolicyNotFoundException;
import org.apache.fineract.useradministration.service.PasswordPreferencesWritePlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;

public class PasswordPreferencesWritePlatformServiceJpaRepositoryImpl
implements PasswordPreferencesWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PasswordPreferencesWritePlatformServiceJpaRepositoryImpl.class);
    private final PasswordValidationPolicyRepository validationRepository;
    private final PasswordPreferencesDataValidator dataValidator;

    @Transactional
    public CommandProcessingResult updatePreferences(JsonCommand command) {
        this.dataValidator.validateForUpdate(command.json());
        Long validationPolicyId = command.longValueOfParameterNamed("validationPolicyId");
        try {
            List validationPolicies = this.validationRepository.findAll();
            Map changes = new HashMap(1);
            boolean found = false;
            for (PasswordValidationPolicy policy : validationPolicies) {
                if (((Long)policy.getId()).equals(validationPolicyId)) {
                    found = true;
                    if (policy.isActive()) continue;
                    changes = policy.activate();
                    continue;
                }
                if (!policy.isActive() || ((Long)policy.getId()).equals(validationPolicyId)) continue;
                policy.deActivate();
            }
            if (!found) {
                throw new PasswordValidationPolicyNotFoundException(validationPolicyId);
            }
            if (!changes.isEmpty()) {
                this.validationRepository.saveAll((Iterable)validationPolicies);
                this.validationRepository.flush();
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            log.error("Error occured.", dve);
            throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.password.validation.policy.unknown.data.integrity.issue", (String)"Unknown data integrity issue with resource.");
        }
    }

    @Generated
    public PasswordPreferencesWritePlatformServiceJpaRepositoryImpl(PasswordValidationPolicyRepository validationRepository, PasswordPreferencesDataValidator dataValidator) {
        this.validationRepository = validationRepository;
        this.dataValidator = dataValidator;
    }
}

