/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.14.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.fineract.client.models.GetSelfUserDetailsOrganisationalRole;
import org.apache.fineract.client.models.GetSelfUserDetailsRoles;

/**
 * GetSelfUserDetailsResponse
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class GetSelfUserDetailsResponse {
  public static final String SERIALIZED_NAME_AUTHENTICATED = "authenticated";
  @SerializedName(SERIALIZED_NAME_AUTHENTICATED)
  private Boolean authenticated;

  public static final String SERIALIZED_NAME_BASE64_ENCODED_AUTHENTICATION_KEY = "base64EncodedAuthenticationKey";
  @SerializedName(SERIALIZED_NAME_BASE64_ENCODED_AUTHENTICATION_KEY)
  private String base64EncodedAuthenticationKey;

  public static final String SERIALIZED_NAME_CLIENTS = "clients";
  @SerializedName(SERIALIZED_NAME_CLIENTS)
  private List<Long> clients;

  public static final String SERIALIZED_NAME_IS_SELF_SERVICE_USER = "isSelfServiceUser";
  @SerializedName(SERIALIZED_NAME_IS_SELF_SERVICE_USER)
  private Boolean isSelfServiceUser;

  public static final String SERIALIZED_NAME_OFFICE_ID = "officeId";
  @SerializedName(SERIALIZED_NAME_OFFICE_ID)
  private Long officeId;

  public static final String SERIALIZED_NAME_OFFICE_NAME = "officeName";
  @SerializedName(SERIALIZED_NAME_OFFICE_NAME)
  private String officeName;

  public static final String SERIALIZED_NAME_ORGANISATIONAL_ROLE = "organisationalRole";
  @SerializedName(SERIALIZED_NAME_ORGANISATIONAL_ROLE)
  private GetSelfUserDetailsOrganisationalRole organisationalRole;

  public static final String SERIALIZED_NAME_PERMISSIONS = "permissions";
  @SerializedName(SERIALIZED_NAME_PERMISSIONS)
  private List<String> permissions;

  public static final String SERIALIZED_NAME_ROLES = "roles";
  @SerializedName(SERIALIZED_NAME_ROLES)
  private Set<GetSelfUserDetailsRoles> roles;

  public static final String SERIALIZED_NAME_STAFF_DISPLAY_NAME = "staffDisplayName";
  @SerializedName(SERIALIZED_NAME_STAFF_DISPLAY_NAME)
  private String staffDisplayName;

  public static final String SERIALIZED_NAME_STAFF_ID = "staffId";
  @SerializedName(SERIALIZED_NAME_STAFF_ID)
  private Long staffId;

  public static final String SERIALIZED_NAME_USER_ID = "userId";
  @SerializedName(SERIALIZED_NAME_USER_ID)
  private Long userId;

  public static final String SERIALIZED_NAME_USERNAME = "username";
  @SerializedName(SERIALIZED_NAME_USERNAME)
  private String username;

  public GetSelfUserDetailsResponse() {
  }

  public GetSelfUserDetailsResponse authenticated(Boolean authenticated) {
    
    this.authenticated = authenticated;
    return this;
  }

  /**
   * Get authenticated
   * @return authenticated
   */
  @javax.annotation.Nullable

  public Boolean getAuthenticated() {
    return authenticated;
  }


  public void setAuthenticated(Boolean authenticated) {
    this.authenticated = authenticated;
  }

  public GetSelfUserDetailsResponse base64EncodedAuthenticationKey(String base64EncodedAuthenticationKey) {
    
    this.base64EncodedAuthenticationKey = base64EncodedAuthenticationKey;
    return this;
  }

  /**
   * Get base64EncodedAuthenticationKey
   * @return base64EncodedAuthenticationKey
   */
  @javax.annotation.Nullable

  public String getBase64EncodedAuthenticationKey() {
    return base64EncodedAuthenticationKey;
  }


  public void setBase64EncodedAuthenticationKey(String base64EncodedAuthenticationKey) {
    this.base64EncodedAuthenticationKey = base64EncodedAuthenticationKey;
  }

  public GetSelfUserDetailsResponse clients(List<Long> clients) {
    
    this.clients = clients;
    return this;
  }

  public GetSelfUserDetailsResponse addClientsItem(Long clientsItem) {
    if (this.clients == null) {
      this.clients = new ArrayList<>();
    }
    this.clients.add(clientsItem);
    return this;
  }

  /**
   * Get clients
   * @return clients
   */
  @javax.annotation.Nullable

  public List<Long> getClients() {
    return clients;
  }


  public void setClients(List<Long> clients) {
    this.clients = clients;
  }

  public GetSelfUserDetailsResponse isSelfServiceUser(Boolean isSelfServiceUser) {
    
    this.isSelfServiceUser = isSelfServiceUser;
    return this;
  }

  /**
   * Get isSelfServiceUser
   * @return isSelfServiceUser
   */
  @javax.annotation.Nullable

  public Boolean getIsSelfServiceUser() {
    return isSelfServiceUser;
  }


  public void setIsSelfServiceUser(Boolean isSelfServiceUser) {
    this.isSelfServiceUser = isSelfServiceUser;
  }

  public GetSelfUserDetailsResponse officeId(Long officeId) {
    
    this.officeId = officeId;
    return this;
  }

  /**
   * Get officeId
   * @return officeId
   */
  @javax.annotation.Nullable

  public Long getOfficeId() {
    return officeId;
  }


  public void setOfficeId(Long officeId) {
    this.officeId = officeId;
  }

  public GetSelfUserDetailsResponse officeName(String officeName) {
    
    this.officeName = officeName;
    return this;
  }

  /**
   * Get officeName
   * @return officeName
   */
  @javax.annotation.Nullable

  public String getOfficeName() {
    return officeName;
  }


  public void setOfficeName(String officeName) {
    this.officeName = officeName;
  }

  public GetSelfUserDetailsResponse organisationalRole(GetSelfUserDetailsOrganisationalRole organisationalRole) {
    
    this.organisationalRole = organisationalRole;
    return this;
  }

  /**
   * Get organisationalRole
   * @return organisationalRole
   */
  @javax.annotation.Nullable

  public GetSelfUserDetailsOrganisationalRole getOrganisationalRole() {
    return organisationalRole;
  }


  public void setOrganisationalRole(GetSelfUserDetailsOrganisationalRole organisationalRole) {
    this.organisationalRole = organisationalRole;
  }

  public GetSelfUserDetailsResponse permissions(List<String> permissions) {
    
    this.permissions = permissions;
    return this;
  }

  public GetSelfUserDetailsResponse addPermissionsItem(String permissionsItem) {
    if (this.permissions == null) {
      this.permissions = new ArrayList<>();
    }
    this.permissions.add(permissionsItem);
    return this;
  }

  /**
   * Get permissions
   * @return permissions
   */
  @javax.annotation.Nullable

  public List<String> getPermissions() {
    return permissions;
  }


  public void setPermissions(List<String> permissions) {
    this.permissions = permissions;
  }

  public GetSelfUserDetailsResponse roles(Set<GetSelfUserDetailsRoles> roles) {
    
    this.roles = roles;
    return this;
  }

  public GetSelfUserDetailsResponse addRolesItem(GetSelfUserDetailsRoles rolesItem) {
    if (this.roles == null) {
      this.roles = new LinkedHashSet<>();
    }
    this.roles.add(rolesItem);
    return this;
  }

  /**
   * Get roles
   * @return roles
   */
  @javax.annotation.Nullable

  public Set<GetSelfUserDetailsRoles> getRoles() {
    return roles;
  }


  public void setRoles(Set<GetSelfUserDetailsRoles> roles) {
    this.roles = roles;
  }

  public GetSelfUserDetailsResponse staffDisplayName(String staffDisplayName) {
    
    this.staffDisplayName = staffDisplayName;
    return this;
  }

  /**
   * Get staffDisplayName
   * @return staffDisplayName
   */
  @javax.annotation.Nullable

  public String getStaffDisplayName() {
    return staffDisplayName;
  }


  public void setStaffDisplayName(String staffDisplayName) {
    this.staffDisplayName = staffDisplayName;
  }

  public GetSelfUserDetailsResponse staffId(Long staffId) {
    
    this.staffId = staffId;
    return this;
  }

  /**
   * Get staffId
   * @return staffId
   */
  @javax.annotation.Nullable

  public Long getStaffId() {
    return staffId;
  }


  public void setStaffId(Long staffId) {
    this.staffId = staffId;
  }

  public GetSelfUserDetailsResponse userId(Long userId) {
    
    this.userId = userId;
    return this;
  }

  /**
   * Get userId
   * @return userId
   */
  @javax.annotation.Nullable

  public Long getUserId() {
    return userId;
  }


  public void setUserId(Long userId) {
    this.userId = userId;
  }

  public GetSelfUserDetailsResponse username(String username) {
    
    this.username = username;
    return this;
  }

  /**
   * Get username
   * @return username
   */
  @javax.annotation.Nullable

  public String getUsername() {
    return username;
  }


  public void setUsername(String username) {
    this.username = username;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetSelfUserDetailsResponse getSelfUserDetailsResponse = (GetSelfUserDetailsResponse) o;
    return Objects.equals(this.authenticated, getSelfUserDetailsResponse.authenticated) &&
        Objects.equals(this.base64EncodedAuthenticationKey, getSelfUserDetailsResponse.base64EncodedAuthenticationKey) &&
        Objects.equals(this.clients, getSelfUserDetailsResponse.clients) &&
        Objects.equals(this.isSelfServiceUser, getSelfUserDetailsResponse.isSelfServiceUser) &&
        Objects.equals(this.officeId, getSelfUserDetailsResponse.officeId) &&
        Objects.equals(this.officeName, getSelfUserDetailsResponse.officeName) &&
        Objects.equals(this.organisationalRole, getSelfUserDetailsResponse.organisationalRole) &&
        Objects.equals(this.permissions, getSelfUserDetailsResponse.permissions) &&
        Objects.equals(this.roles, getSelfUserDetailsResponse.roles) &&
        Objects.equals(this.staffDisplayName, getSelfUserDetailsResponse.staffDisplayName) &&
        Objects.equals(this.staffId, getSelfUserDetailsResponse.staffId) &&
        Objects.equals(this.userId, getSelfUserDetailsResponse.userId) &&
        Objects.equals(this.username, getSelfUserDetailsResponse.username);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authenticated, base64EncodedAuthenticationKey, clients, isSelfServiceUser, officeId, officeName, organisationalRole, permissions, roles, staffDisplayName, staffId, userId, username);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetSelfUserDetailsResponse {\n");
    sb.append("    authenticated: ").append(toIndentedString(authenticated)).append("\n");
    sb.append("    base64EncodedAuthenticationKey: ").append(toIndentedString(base64EncodedAuthenticationKey)).append("\n");
    sb.append("    clients: ").append(toIndentedString(clients)).append("\n");
    sb.append("    isSelfServiceUser: ").append(toIndentedString(isSelfServiceUser)).append("\n");
    sb.append("    officeId: ").append(toIndentedString(officeId)).append("\n");
    sb.append("    officeName: ").append(toIndentedString(officeName)).append("\n");
    sb.append("    organisationalRole: ").append(toIndentedString(organisationalRole)).append("\n");
    sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
    sb.append("    roles: ").append(toIndentedString(roles)).append("\n");
    sb.append("    staffDisplayName: ").append(toIndentedString(staffDisplayName)).append("\n");
    sb.append("    staffId: ").append(toIndentedString(staffId)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    username: ").append(toIndentedString(username)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

