# Custom Log Label Examples

The following are examples illustrating how to add custom labels to logs generated by UserALE.js. Custom labels are
useful in cases where one would prefer to use a more descriptive label for an element users interact with or when
logging information about a specific feature.

## Adding Custom Labels to Logs

### Example 1

Consider the following HTML:

```html

<div>
    <button>New Feature</button>
</div>
```

The following code snippet will add a custom field, `customLabel`, and send a log whenever the new feature button is
clicked:

```js
window.userale.map((log, e) => {
    // determine whether we want to add custom labels to the log
    if (e && e.target.innerHTML !== 'New Feature') {
        return log; // normal logging
    }
    // if the event occurred on the New Feature, add custom labeling
    return {
        ...log,
        customLabel: 'New Feature',
        logType: 'custom',
    };
});
```

### Example 2

Let's say you want to generate logs on custom events, or events not currently supported by UserALE.js. In this case, you
can add an event listener and use the `customPackageLog` function as shown below:

```js
    document.addEventListener('customEvent', function (e) {
        window.userale.packageCustomLog({
            type: 'customEvent',
            customLabel: 'custom label',
            customField1: 'custom field',
        }, () => ({customDetails: Date.now()}), true);
    }
);
```

This event listener will now be invoked on the `customEvent` and send a custom log to the backend. Note that the
`packageCustomLog` function also adds the typical metadata used in the UserALE.js logs.

Note that we only advise adding custom event listeners in the following scenarios:

1. For events not captured natively by UserALE.js (as seen above)
2. For sending custom logs *only*