/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import macromedia.abc.BytecodeBuffer;
import macromedia.abc.DecoderException;

public final class Scanner {
    public static int scanMinorVersion(BytecodeBuffer in) {
        int position = in.pos();
        in.skip(2L);
        return position;
    }

    public static int scanMajorVersion(BytecodeBuffer in) {
        int position = in.pos();
        in.skip(2L);
        return position;
    }

    public static int[] scanIntConstants(BytecodeBuffer in) {
        int size = in.readU32();
        int[] positions = new int[size];
        for (int i = 1; i < size; ++i) {
            positions[i] = in.pos();
            in.readU32();
        }
        return positions;
    }

    public static int[] scanUIntConstants(BytecodeBuffer in) {
        int size = in.readU32();
        int[] positions = new int[size];
        for (int i = 1; i < size; ++i) {
            positions[i] = in.pos();
            in.readU32();
        }
        return positions;
    }

    public static int[] scanDoubleConstants(BytecodeBuffer in) {
        int size = in.readU32();
        int[] positions = new int[size];
        for (int i = 1; i < size; ++i) {
            positions[i] = in.pos();
            in.readDouble();
        }
        return positions;
    }

    public static int[] scanDecimalConstants(BytecodeBuffer in) {
        int size = in.readU32();
        int[] positions = new int[size];
        for (int i = 1; i < size; ++i) {
            positions[i] = in.pos();
            in.readBytes(16);
        }
        return positions;
    }

    public static int[] scanStrConstants(BytecodeBuffer in) {
        int size = in.readU32();
        int[] positions = new int[size];
        for (int i = 1; i < size; ++i) {
            positions[i] = in.pos();
            long length = in.readU32();
            in.skip(length);
        }
        return positions;
    }

    public static int[] scanNsConstants(BytecodeBuffer in) {
        int size = in.readU32();
        int[] positions = new int[size];
        for (int i = 1; i < size; ++i) {
            positions[i] = in.pos();
            in.readU8();
            in.readU32();
        }
        return positions;
    }

    public static int[] scanNsSetConstants(BytecodeBuffer in) {
        int size = in.readU32();
        int[] positions = new int[size];
        for (int i = 1; i < size; ++i) {
            positions[i] = in.pos();
            long count = in.readU32();
            in.skipEntries(count);
        }
        return positions;
    }

    public static int[] scanMultinameConstants(BytecodeBuffer in) throws DecoderException {
        int size = in.readU32();
        int[] positions = new int[size];
        block8: for (int i = 1; i < size; ++i) {
            positions[i] = in.pos();
            int kind = in.readU8();
            switch (kind) {
                case 7: 
                case 13: {
                    in.readU32();
                    in.readU32();
                    continue block8;
                }
                case 15: 
                case 16: {
                    in.readU32();
                    continue block8;
                }
                case 9: 
                case 14: {
                    in.readU32();
                    in.readU32();
                    continue block8;
                }
                case 17: 
                case 18: {
                    continue block8;
                }
                case 27: 
                case 28: {
                    in.readU32();
                    continue block8;
                }
                case 29: {
                    in.readU32();
                    long count = in.readU32();
                    in.skipEntries(count);
                    continue block8;
                }
                default: {
                    throw new DecoderException("Invalid constant type: " + kind);
                }
            }
        }
        return positions;
    }

    public static int[] scanMethods(BytecodeBuffer in) {
        int size = in.readU32();
        int[] positions = new int[size];
        for (int i = 0; i < size; ++i) {
            positions[i] = in.pos();
            long paramCount = in.readU32();
            in.readU32();
            in.skipEntries(paramCount);
            in.readU32();
            int flags = in.readU8();
            long optionalCount = (flags & 8) != 0 ? (long)in.readU32() : 0L;
            for (long q = 0L; q < optionalCount; ++q) {
                in.readU32();
                in.readU8();
            }
            long paramNameCount = (flags & 0x80) != 0 ? paramCount : 0L;
            for (long q = 0L; q < paramNameCount; ++q) {
                in.readU32();
            }
        }
        return positions;
    }

    public static int[] scanMetadata(BytecodeBuffer in) {
        int size = in.readU32();
        int[] positions = new int[size];
        for (int i = 0; i < size; ++i) {
            positions[i] = in.pos();
            in.readU32();
            long value_count = in.readU32();
            in.skipEntries(value_count * 2L);
        }
        return positions;
    }

    public static int[] scanInstances(BytecodeBuffer in, int size) {
        int[] positions = new int[size];
        for (int i = 0; i < size; ++i) {
            positions[i] = in.pos();
            in.skipEntries(2L);
            int flags = in.readU8();
            if ((flags & 8) != 0) {
                in.readU32();
            }
            long interfaceCount = in.readU32();
            in.skipEntries(interfaceCount);
            in.readU32();
            Scanner.scanTraits(in);
        }
        return positions;
    }

    public static int[] scanClasses(BytecodeBuffer in, int size) {
        int[] positions = new int[size];
        for (int i = 0; i < size; ++i) {
            positions[i] = in.pos();
            in.readU32();
            Scanner.scanTraits(in);
        }
        return positions;
    }

    public static int[] scanScripts(BytecodeBuffer in) {
        int size = in.readU32();
        int[] positions = new int[size];
        for (int i = 0; i < size; ++i) {
            positions[i] = in.pos();
            in.readU32();
            Scanner.scanTraits(in);
        }
        return positions;
    }

    public static int[] scanMethodBodies(BytecodeBuffer in) {
        int size = in.readU32();
        int[] positions = new int[size];
        for (int i = 0; i < size; ++i) {
            positions[i] = in.pos();
            in.skipEntries(5L);
            long codeLength = in.readU32();
            in.skip((int)codeLength);
            Scanner.scanExceptions(in);
            Scanner.scanTraits(in);
        }
        return positions;
    }

    private static void scanExceptions(BytecodeBuffer in) {
        long count = in.readU32();
        if (in.minorVersion() == 15) {
            in.skipEntries(count * 4L);
        } else {
            in.skipEntries(count * 5L);
        }
    }

    private static void scanTraits(BytecodeBuffer in) {
        long count = in.readU32();
        for (long i = 0L; i < count; ++i) {
            in.readU32();
            int kind = in.readU8();
            int tag = kind & 0xF;
            switch (tag) {
                case 0: 
                case 6: {
                    in.skipEntries(2L);
                    int valueId = in.readU32();
                    if (valueId <= 0) break;
                    in.readU8();
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    in.skipEntries(2L);
                    break;
                }
                case 4: 
                case 5: {
                    in.skipEntries(2L);
                    break;
                }
                default: {
                    System.err.println("invalid trait type: " + tag);
                }
            }
            if ((kind >> 4 & 4) == 0) continue;
            long metadata = in.readU32();
            in.skipEntries(metadata);
        }
    }
}

