/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flex2.compiler.CompilationUnit;
import flex2.compiler.swc.ScriptImpl;
import flex2.compiler.swc.SwcDependencySet;
import flex2.compiler.swc.SwcLibrary;
import flex2.tools.oem.Script;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwcScript {
    private final SwcLibrary library;
    private final long modtime;
    private final Long signatureChecksum;
    private final Set<String> defs;
    private final String name;
    private final SwcDependencySet deps;
    private Set<String> symbolClasses;
    private CompilationUnit compilationUnit;
    private byte[] abc;

    public SwcScript(SwcLibrary library, String name, Set<String> defs, SwcDependencySet deps, long modtime, Long signatureChecksum) {
        this.library = library;
        this.name = name;
        this.defs = defs;
        this.deps = deps;
        this.modtime = modtime;
        this.signatureChecksum = signatureChecksum;
    }

    void setABC(byte[] abc) {
        assert (abc != null);
        this.abc = abc;
    }

    public byte[] getABC() {
        this.library.parse();
        assert (this.abc != null);
        return this.abc;
    }

    public SwcLibrary getLibrary() {
        return this.library;
    }

    public String getSwcLocation() {
        return this.library.getSwcLocation();
    }

    public String getName() {
        return this.name;
    }

    public long getLastModified() {
        return this.modtime;
    }

    public Iterator<String> getDefinitionIterator() {
        return this.defs.iterator();
    }

    public SwcDependencySet getDependencySet() {
        return this.deps;
    }

    public CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public void setCompilationUnit(CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
        if (compilationUnit != null && compilationUnit.isBytecodeAvailable() && this.abc == null) {
            this.abc = compilationUnit.getByteCodes();
        }
    }

    public Set<String> getSymbolClasses() {
        if (this.symbolClasses == null) {
            this.symbolClasses = new HashSet<String>();
            Iterator<String> i = this.getDefinitionIterator();
            while (i.hasNext()) {
                this.library.getSymbolClasses(i.next(), this.symbolClasses);
            }
        }
        return this.symbolClasses;
    }

    public Script toScript(boolean includeBytecodes) {
        return new ScriptImpl(this, includeBytecodes);
    }

    public Long getSignatureChecksum() {
        return this.signatureChecksum;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getSwcLocation());
        builder.append("(");
        Iterator<String> iterator = this.defs.iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(")");
        return builder.toString();
    }
}

