/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.swf.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import org.apache.flex.swf.io.IOutputBitStream;
import org.apache.flex.utils.DAByteArrayOutputStream;

public class OutputBitStream
implements IOutputBitStream {
    private final OutputStream filteredOutput;
    private final DAByteArrayOutputStream flatOutputBuffer;
    private int bitPos = 8;
    private byte currentByte = 0;
    private final boolean useCompression;

    public OutputBitStream() {
        this(false);
    }

    public OutputBitStream(boolean useCompression) {
        this.useCompression = useCompression;
        this.flatOutputBuffer = new DAByteArrayOutputStream();
        this.filteredOutput = useCompression ? new DeflaterOutputStream(this.flatOutputBuffer) : this.flatOutputBuffer;
    }

    @Override
    public int getBitPos() {
        return this.bitPos;
    }

    @Override
    public void byteAlign() {
        if (this.bitPos != 8) {
            this.writeByte(this.currentByte);
            this.currentByte = 0;
            this.bitPos = 8;
        }
    }

    @Override
    public void close() throws IOException {
        this.filteredOutput.close();
    }

    @Override
    public void flush() {
        this.byteAlign();
        try {
            if (this.useCompression) {
                ((DeflaterOutputStream)this.filteredOutput).finish();
            }
            this.filteredOutput.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] getBytes() {
        this.flush();
        return this.flatOutputBuffer.getDirectByteArray();
    }

    @Override
    public void reset() {
        this.flatOutputBuffer.reset();
    }

    @Override
    public int size() {
        return this.flatOutputBuffer.size();
    }

    public byte[] toByteArray() {
        return this.flatOutputBuffer.toByteArray();
    }

    @Override
    public void write(byte[] data) {
        try {
            this.filteredOutput.write(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(byte[] data, int off, int len) {
        try {
            this.filteredOutput.write(data, off, len);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeBit(boolean data) {
        this.writeUB(data ? 1 : 0, 1);
    }

    private void writeBits(int data, int size) {
        while (size > 0) {
            if (size > this.bitPos) {
                this.currentByte = (byte)(this.currentByte | data << 32 - size >>> 32 - this.bitPos);
                this.writeByte(this.currentByte);
                size -= this.bitPos;
                this.currentByte = 0;
                this.bitPos = 8;
                continue;
            }
            this.currentByte = (byte)(this.currentByte | data << 32 - size >>> 32 - this.bitPos);
            this.bitPos -= size;
            size = 0;
            if (this.bitPos != 0) continue;
            this.writeByte(this.currentByte);
            this.currentByte = 0;
            this.bitPos = 8;
        }
    }

    private void writeByte(int value) {
        try {
            this.filteredOutput.write(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeByte(long value) {
        this.writeByte((int)value);
    }

    @Override
    public void writeDOUBLE(double value) {
        this.writeSI64(Double.doubleToLongBits(value));
    }

    @Override
    public void writeEncodedU32(long value) {
        value &= 0xFFFFFFFFL;
        do {
            byte fragment = (byte)(value & 0x7FL);
            if ((value >>= 7) > 0L) {
                fragment = (byte)(fragment | 0x80);
            }
            this.writeByte(fragment);
        } while (value > 0L);
    }

    @Override
    public void writeFB(double data, int size) {
        int bits = (int)(data * 65536.0);
        this.writeSB(bits, size);
    }

    @Override
    public void writeFIXED(double value) {
        int bytes = (int)(value * 65536.0) & 0xFFFFFFFF;
        this.writeUI32(bytes);
    }

    @Override
    public void writeFIXED8(double value) {
        int bytes = (int)(value * 256.0) & 0xFFFF;
        this.writeUI16(bytes);
    }

    @Override
    public void writeFLOAT(float value) {
        this.writeSI32(Float.floatToIntBits(value));
    }

    @Override
    public void writeSB(int data, int size) {
        assert (data >= -(1 << size - 1) && data <= (1 << size - 1) - 1);
        this.writeBits(data, size);
    }

    @Override
    public void writeSI16(int value) {
        this.writeByte(value);
        this.writeByte(value >> 8);
    }

    @Override
    public void writeSI32(int value) {
        this.writeByte(value);
        this.writeByte(value >> 8);
        this.writeByte(value >> 16);
        this.writeByte(value >> 24);
    }

    @Override
    public void writeSI64(long value) {
        this.writeSI32((int)value);
        this.writeSI32((int)(value >> 32));
    }

    @Override
    public void writeSI8(int value) {
        this.writeByte(value);
    }

    @Override
    public void writeString(String value) {
        try {
            this.filteredOutput.write(value.getBytes("UTF-8"));
            this.filteredOutput.write(0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeUB(int data, int size) {
        assert (data >= 0 && data <= (1 << size) - 1);
        this.writeBits(data, size);
    }

    @Override
    public void writeUI16(int value) {
        this.writeSI16(value);
    }

    @Override
    public void writeUI24(long value) {
        this.writeByte(value);
        this.writeByte(value >> 8);
        this.writeByte(value >> 16);
    }

    @Override
    public void writeUI32(long value) {
        this.writeByte(value);
        this.writeByte(value >> 8);
        this.writeByte(value >> 16);
        this.writeByte(value >> 24);
    }

    @Override
    public void writeUI8(int value) {
        this.writeByte(value);
    }
}

