/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.ant.types;

import org.apache.flex.compiler.ant.config.IOptionSource;
import org.apache.flex.compiler.ant.config.OptionSpec;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicAttribute;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FlexInteger;

public class DefaultScriptLimits
implements DynamicAttribute,
IOptionSource {
    public static final OptionSpec DEFAULT_SCRIPT_LIMITS = new OptionSpec("default-script-limits");
    private int maxRecursionDepth = -1;
    private int maxExecutionTime = -1;

    public void setDynamicAttribute(String name, String value) {
        int intVal = new FlexInteger(value).intValue();
        if (name.equals("max-recursion-depth")) {
            this.maxRecursionDepth = intVal;
        } else if (name.equals("max-execution-time")) {
            this.maxExecutionTime = intVal;
        } else {
            throw new BuildException("The <default-script-limits> type doesn't support the \"" + name + "\" attribute.");
        }
        if (intVal < 0) {
            throw new BuildException(name + "attribute must be a positive integer!");
        }
    }

    @Override
    public void addToCommandline(Commandline cmdline) {
        if (this.maxRecursionDepth == -1) {
            throw new BuildException("max-recursion-depth attribute must be set!");
        }
        if (this.maxExecutionTime == -1) {
            throw new BuildException("max-execution-time attribute must be set!");
        }
        cmdline.createArgument().setValue("-" + DEFAULT_SCRIPT_LIMITS.getFullName());
        cmdline.createArgument().setValue(String.valueOf(this.maxRecursionDepth));
        cmdline.createArgument().setValue(String.valueOf(this.maxExecutionTime));
    }
}

