/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.parsing.as;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import org.apache.flex.compiler.internal.parsing.TokenBase;
import org.apache.flex.compiler.internal.parsing.as.ASTokenTypes;
import org.apache.flex.compiler.parsing.IASToken;
import org.apache.flex.compiler.parsing.ICMToken;

public class ASToken
extends TokenBase
implements IASToken,
ASTokenTypes {
    public static final int UNKNOWN_OPEN_BLOCK_TOKEN_TYPE = -1;
    private static ImmutableMap<Integer, String> tokenNames;
    private static final ASToken TOKEN_TYPE_TO_KIND_CONVERTER;

    public ASToken(int tokenType, int start, int end, int line, int column, CharSequence tokenText) {
        super(tokenType, start, end, line, column, tokenText);
    }

    public ASToken(ASToken other) {
        super(other);
    }

    public ASToken clone() {
        return new ASToken(this);
    }

    @Override
    public ICMToken changeType(int type) {
        return new ASToken(type, this.getStart(), this.getEnd(), this.getLine(), this.getColumn(), this.getText());
    }

    public static final boolean isOpenToken(int tokenType) {
        switch (tokenType) {
            case 19: 
            case 37: 
            case 45: 
            case 150: {
                return true;
            }
        }
        return false;
    }

    public static final int getOpenBlockTokenType(int tokenType) {
        switch (tokenType) {
            case 11: 
            case 16: 
            case 17: 
            case 57: 
            case 59: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                return 19;
            }
            case 42: {
                return 19;
            }
            case 44: {
                return 19;
            }
            case 39: {
                return 19;
            }
            case 38: {
                return 19;
            }
        }
        return -1;
    }

    public final int getOpenBlockTokenType() {
        return ASToken.getOpenBlockTokenType(this.type);
    }

    public final boolean isOpenBlockToken() {
        return ASToken.isOpenBlockToken(this.getType());
    }

    public static final boolean isOpenBlockToken(int tokenType) {
        switch (tokenType) {
            case 19: 
            case 150: {
                return true;
            }
        }
        return false;
    }

    public final boolean isOpenToken() {
        return ASToken.isOpenToken(this.getType());
    }

    public static final boolean isCloseToken(int tokenType) {
        switch (tokenType) {
            case 20: 
            case 46: 
            case 126: 
            case 151: {
                return true;
            }
        }
        return false;
    }

    public final boolean isCloseBlockToken() {
        return ASToken.isCloseBlockToken(this.getType());
    }

    public static final boolean isCloseBlockToken(int tokenType) {
        switch (tokenType) {
            case 20: 
            case 151: {
                return true;
            }
        }
        return false;
    }

    public final boolean isCloseToken() {
        return ASToken.isCloseToken(this.getType());
    }

    public static final int getBalancingToken(int tokenType) {
        switch (tokenType) {
            case 45: {
                return 46;
            }
            case 46: {
                return 45;
            }
            case 19: {
                return 20;
            }
            case 20: {
                return 19;
            }
            case 71: {
                return 72;
            }
            case 127: {
                return 128;
            }
            case 128: {
                return 127;
            }
            case 37: {
                return 126;
            }
            case 126: {
                return 37;
            }
            case 72: {
                return 71;
            }
            case 150: {
                return 151;
            }
            case 151: {
                return 150;
            }
        }
        return 0;
    }

    public final int getBalancingToken() {
        return ASToken.getBalancingToken(this.getType());
    }

    private static final boolean canCauseContainmentProblems(int tokenType) {
        switch (tokenType) {
            case 19: 
            case 20: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 50: {
                return true;
            }
        }
        return false;
    }

    public final boolean canCauseContainmentProblems() {
        return ASToken.canCauseContainmentProblems(this.getType());
    }

    public final boolean isOperator() {
        return ASToken.isOperator(this);
    }

    private static final boolean isOperator(ASToken token) {
        switch (token.getType()) {
            case 22: 
            case 35: 
            case 52: 
            case 58: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 153: 
            case 154: {
                return true;
            }
        }
        return false;
    }

    public final boolean isE4X() {
        return ASToken.isE4X(this.type);
    }

    public static final boolean isE4X(int type) {
        switch (type) {
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: {
                return true;
            }
        }
        return false;
    }

    public final boolean isLiteral() {
        return ASToken.isLiteral(this.type);
    }

    private static final boolean isLiteral(int type) {
        switch (type) {
            case 18: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 148: 
            case 149: {
                return true;
            }
        }
        return false;
    }

    public static final boolean isDefinitionKeyword(int type) {
        switch (type) {
            case 27: 
            case 39: 
            case 42: 
            case 44: 
            case 50: 
            case 51: {
                return true;
            }
        }
        return false;
    }

    public static boolean isModifier(int type) {
        switch (type) {
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return true;
            }
        }
        return false;
    }

    public final boolean isModifier() {
        return ASToken.isModifier(this.type);
    }

    public static final boolean isStatementKeyword(int type) {
        switch (type) {
            case 16: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                return true;
            }
        }
        return false;
    }

    public final boolean isStatementKeyword() {
        return ASToken.isStatementKeyword(this.type);
    }

    public final boolean isContextualReservedWord() {
        switch (this.type) {
            case 11: 
            case 12: 
            case 14: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 40: 
            case 43: 
            case 47: 
            case 48: {
                return true;
            }
        }
        return false;
    }

    public final boolean isKeyword() {
        switch (this.type) {
            case 13: 
            case 16: 
            case 17: 
            case 25: 
            case 26: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 50: 
            case 51: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 100: 
            case 101: 
            case 102: 
            case 111: 
            case 114: 
            case 115: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 152: {
                return true;
            }
        }
        return false;
    }

    public final boolean isKeywordOrContextualReservedWord() {
        return this.isKeyword() || this.isContextualReservedWord();
    }

    public static final boolean canExistInMetadata(int tokenType) {
        switch (tokenType) {
            case 13: 
            case 15: 
            case 18: 
            case 41: 
            case 45: 
            case 46: 
            case 52: 
            case 69: 
            case 118: 
            case 119: 
            case 120: 
            case 124: 
            case 125: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    public final boolean canExistInMetadata() {
        return ASToken.canExistInMetadata(this.type);
    }

    public static final boolean canFollowMetadata(int tokenType) {
        switch (tokenType) {
            case 5: 
            case 8: 
            case 15: 
            case 28: 
            case 37: {
                return true;
            }
        }
        return false;
    }

    public final boolean canFollowMetadata() {
        return ASToken.canFollowMetadata(this.type);
    }

    public static final boolean canFollowUserNamespaceAnnotation(int tokenType) {
        switch (tokenType) {
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 44: 
            case 50: 
            case 51: {
                return true;
            }
        }
        return false;
    }

    public final boolean canFollowUserNamespace() {
        return ASToken.canFollowUserNamespaceAnnotation(this.type);
    }

    public final boolean canPreceedAnonymousFunction() {
        switch (this.type) {
            case 24: 
            case 37: 
            case 41: 
            case 45: 
            case 52: 
            case 55: 
            case 152: {
                return true;
            }
        }
        return false;
    }

    public static final boolean canPreceedSignedOperator(int tokenType) {
        if (ASToken.isLiteral(tokenType)) {
            return true;
        }
        switch (tokenType) {
            case 15: 
            case 46: 
            case 70: 
            case 112: 
            case 113: 
            case 121: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    public final boolean canPreceedSignedOperator() {
        return ASToken.canPreceedSignedOperator(this.type);
    }

    public final boolean canPreceedE4X() {
        return ASToken.canPreceedE4X(this.type);
    }

    public static final boolean canPreceedE4X(int tokenType) {
        switch (tokenType) {
            case -1: 
            case 24: 
            case 37: 
            case 41: 
            case 45: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 116: 
            case 117: {
                return true;
            }
        }
        return false;
    }

    public static final boolean canPreceedRegex(int tokenType) {
        switch (tokenType) {
            case -1: 
            case 19: 
            case 20: 
            case 24: 
            case 37: 
            case 41: 
            case 45: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                return true;
            }
        }
        return false;
    }

    private static synchronized void initializeTokenNames() {
        if (tokenNames != null) {
            return;
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        ASToken token = new ASToken(-1, -1, -1, -1, -1, "");
        for (Field field : ASTokenTypes.class.getFields()) {
            int tokenType;
            if (!field.getType().equals(Integer.TYPE)) continue;
            try {
                tokenType = field.getInt(token);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            builder.put((Object)tokenType, (Object)field.getName());
        }
        tokenNames = builder.build();
    }

    @Override
    protected String getTypeString() {
        ASToken.initializeTokenNames();
        return (String)tokenNames.get((Object)this.getType());
    }

    @Override
    public IASToken.ASTokenKind getTokenKind() {
        switch (this.getType()) {
            case 1: {
                return IASToken.ASTokenKind.EOF;
            }
            case 4: 
            case 5: 
            case 8: 
            case 28: {
                return IASToken.ASTokenKind.COMMENT;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return IASToken.ASTokenKind.MODIFIER;
            }
            case 7: 
            case 23: {
                return IASToken.ASTokenKind.NAMESPACE;
            }
            case 53: {
                return IASToken.ASTokenKind.DEFAULT_XML_STATEMENT;
            }
            case 20: {
                return IASToken.ASTokenKind.SCOPE_CLOSE;
            }
            case 19: {
                return IASToken.ASTokenKind.SCOPE_OPEN;
            }
            case 18: {
                return IASToken.ASTokenKind.STRING_LITERAL;
            }
            case 124: 
            case 125: {
                return IASToken.ASTokenKind.NUMBER_LITERAL;
            }
            case 119: 
            case 120: {
                return IASToken.ASTokenKind.BOOLEAN_LITERAL;
            }
            case 118: 
            case 122: {
                return IASToken.ASTokenKind.OBJECT_LITERAL;
            }
            case 123: {
                return IASToken.ASTokenKind.REGEX_LITERAL;
            }
            case 148: 
            case 149: {
                return IASToken.ASTokenKind.XMLLIST_LITERAL;
            }
            case 45: {
                return IASToken.ASTokenKind.PAREN_OPEN;
            }
            case 46: {
                return IASToken.ASTokenKind.PAREN_CLOSE;
            }
            case 37: {
                return IASToken.ASTokenKind.BRACKET_OPEN;
            }
            case 126: {
                return IASToken.ASTokenKind.BRACKET_CLOSE;
            }
            case 36: {
                return IASToken.ASTokenKind.METADATA;
            }
            case 54: {
                return IASToken.ASTokenKind.SEMICOLON;
            }
            case 24: {
                return IASToken.ASTokenKind.COLON;
            }
            case 41: {
                return IASToken.ASTokenKind.OPERATOR;
            }
            case 151: {
                return IASToken.ASTokenKind.E4X_BINDING_CLOSE;
            }
            case 150: {
                return IASToken.ASTokenKind.E4X_BINDING_OPEN;
            }
            case 72: 
            case 128: {
                return IASToken.ASTokenKind.TYPED_COLLECTION_CLOSE;
            }
            case 71: 
            case 127: {
                return IASToken.ASTokenKind.TYPED_COLLECTION_OPEN;
            }
            case 49: {
                return IASToken.ASTokenKind.OPERATOR;
            }
            case 13: {
                return IASToken.ASTokenKind.INCLUDE;
            }
        }
        if (this.isKeywordOrContextualReservedWord()) {
            return IASToken.ASTokenKind.KEYWORD;
        }
        if (this.isOperator()) {
            return IASToken.ASTokenKind.OPERATOR;
        }
        if (this.getType() == 15) {
            return IASToken.ASTokenKind.IDENTIFIER;
        }
        if (this.isE4X()) {
            return IASToken.ASTokenKind.XML_LITERAL;
        }
        return IASToken.ASTokenKind.UNKNOWN;
    }

    public static synchronized IASToken.ASTokenKind typeToKind(int type) {
        TOKEN_TYPE_TO_KIND_CONVERTER.setType(type);
        return TOKEN_TYPE_TO_KIND_CONVERTER.getTokenKind();
    }

    @Override
    public final boolean isMultiLineComment() {
        return this.getType() == 8 || this.getType() == 28;
    }

    static {
        TOKEN_TYPE_TO_KIND_CONVERTER = new ASToken(1, -1, -1, -1, -1, "");
    }
}

