/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.as;

import java.util.Collection;
import java.util.EnumSet;
import org.apache.flex.compiler.internal.scopes.ASScope;
import org.apache.flex.compiler.internal.scopes.CatchScope;
import org.apache.flex.compiler.internal.semantics.PostProcessStep;
import org.apache.flex.compiler.internal.tree.as.BaseStatementNode;
import org.apache.flex.compiler.internal.tree.as.ParameterNode;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.scopes.IASScope;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.ICatchNode;
import org.apache.flex.compiler.tree.as.IImportNode;
import org.apache.flex.compiler.tree.as.IParameterNode;
import org.apache.flex.compiler.tree.as.IScopedNode;

public class CatchNode
extends BaseStatementNode
implements ICatchNode,
IScopedNode {
    protected ParameterNode argumentNode;
    private ASScope catchScope;

    public CatchNode(ParameterNode argumentNode) {
        this.argumentNode = argumentNode;
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.CatchID;
    }

    @Override
    public int getChildCount() {
        int count = 0;
        if (this.argumentNode != null) {
            ++count;
        }
        if (this.contentsNode != null) {
            ++count;
        }
        return count;
    }

    @Override
    public IASNode getChild(int i) {
        if (i == 0 && this.argumentNode != null) {
            return this.argumentNode;
        }
        if (i == 1 || i == 0 && this.argumentNode == null) {
            return this.contentsNode;
        }
        return null;
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        if (set.contains((Object)PostProcessStep.POPULATE_SCOPE) || set.contains((Object)PostProcessStep.RECONNECT_DEFINITIONS)) {
            this.catchScope = new CatchScope(scope);
            this.catchScope.setContainingScope(scope);
        }
        if (this.contentsNode != null) {
            this.argumentNode.analyze(set, this.catchScope, problems);
            this.contentsNode.analyze(set, this.catchScope, problems);
        }
    }

    @Override
    public IParameterNode getCatchParameterNode() {
        return this.argumentNode;
    }

    @Override
    public IASScope getScope() {
        return this.catchScope;
    }

    @Override
    public void getAllImports(Collection<String> imports) {
        this.getContainingScope().getAllImports(imports);
    }

    @Override
    public void getAllImportNodes(Collection<IImportNode> imports) {
        this.getContainingScope().getAllImportNodes(imports);
    }
}

