/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.externals.utils;

import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.NamedType;
import com.google.javascript.rhino.jstype.UnionType;
import java.util.HashMap;
import org.apache.flex.compiler.internal.codegen.externals.reference.BaseReference;
import org.apache.flex.compiler.internal.codegen.externals.reference.ClassReference;
import org.apache.flex.compiler.internal.codegen.externals.reference.ConstantReference;
import org.apache.flex.compiler.internal.codegen.externals.reference.ReferenceModel;

public class JSTypeUtils {
    public static String toClassTypeString(ClassReference reference) {
        String type = JSTypeUtils.getJsType(reference.getModel(), reference.getComment().getBaseType()).toString();
        return type;
    }

    public static String toParamTypeString(BaseReference reference, String paramName) {
        ClassReference typeDef;
        JSTypeExpression expression = reference.getComment().getParameterType(paramName);
        if (expression == null) {
            return "Object";
        }
        JSType jsType = JSTypeUtils.getJsType(reference.getModel(), expression);
        if (jsType instanceof NamedType && (typeDef = reference.getModel().getTypeDefReference(jsType.getDisplayName())) != null) {
            return "Object";
        }
        String type = JSTypeUtils.toTypeExpressionString(reference, expression);
        type = JSTypeUtils.transformType(type);
        return type;
    }

    public static String toReturnTypeString(BaseReference reference) {
        JSTypeExpression expression = reference.getComment().getReturnType();
        if (expression == null) {
            return "void";
        }
        String type = JSTypeUtils.toTypeExpressionString(reference, expression);
        type = JSTypeUtils.transformType(type);
        return type;
    }

    public static String toFieldTypeString(BaseReference reference) {
        JSTypeExpression expression = reference.getComment().getType();
        if (expression == null) {
            return "Object";
        }
        String type = JSTypeUtils.toTypeExpressionString(reference, expression);
        type = JSTypeUtils.transformType(type);
        return type;
    }

    public static String toEnumTypeString(BaseReference reference) {
        JSTypeExpression enumParameterType = reference.getComment().getEnumParameterType();
        String overrideStringType = JSTypeUtils.transformType(reference.getModel().evaluate(enumParameterType).toAnnotationString());
        return overrideStringType;
    }

    public static String toConstantTypeString(ConstantReference reference) {
        JSTypeExpression expression = reference.getComment().getType();
        if (expression == null) {
            return "Object";
        }
        String type = JSTypeUtils.toTypeExpressionString(reference, expression);
        type = JSTypeUtils.transformType(type);
        return type;
    }

    public static String transformType(String type) {
        int endIndex;
        String typeWithoutComment = type;
        int startIndex = typeWithoutComment.indexOf(" /*");
        if (startIndex != -1 && (endIndex = typeWithoutComment.indexOf("*/", startIndex)) != -1) {
            typeWithoutComment = typeWithoutComment.substring(0, startIndex) + typeWithoutComment.substring(endIndex + 2);
        }
        if (typeWithoutComment.indexOf("|") != -1) {
            return "Object";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("?", "Object /* ? */");
        map.put("*", "*");
        map.put("string", "String");
        map.put("number", "Number");
        map.put("boolean", "Boolean");
        map.put("undefined", "Object /* undefined */");
        map.put("null", "Object /* null */");
        if (map.containsKey(type)) {
            return (String)map.get(type);
        }
        return type;
    }

    private static String toTypeExpressionString(BaseReference reference, JSTypeExpression expression) {
        JSType jsType = JSTypeUtils.getJsType(reference.getModel(), expression);
        String type = JSTypeUtils.toTypeString(jsType);
        return type;
    }

    private static String toTypeString(JSType jsType) {
        String type = jsType.toString();
        if (jsType.isFunctionType()) {
            return "Function /* " + type + " */";
        }
        if (jsType.isRecordType()) {
            return "Object /* " + type + " */";
        }
        if (type.equals("None")) {
            return "* /* " + type + " */";
        }
        if (type.indexOf("Array<") == 0) {
            return "Array";
        }
        if (type.indexOf("Object<") == 0) {
            return "Object";
        }
        return type;
    }

    private static JSType getJsType(ReferenceModel model, JSTypeExpression typeExpression) {
        JSType typeDefJSType;
        JSTypeExpression typeDefTypeExpression;
        ClassReference typeDef;
        UnionType ut;
        JSType jsType2;
        JSType jsType = model.evaluate(typeExpression);
        if (jsType.isUnionType() && !(jsType2 = (ut = (UnionType)jsType).restrictByNotNullOrUndefined()).isUnionType()) {
            jsType = jsType2;
        }
        if ((typeDef = model.getTypeDefReference(jsType.getDisplayName())) != null && (typeDefTypeExpression = typeDef.getComment().getTypedefType()) != null && (typeDefJSType = JSTypeUtils.getJsType(model, typeDefTypeExpression)).isFunctionType()) {
            jsType = typeDefJSType;
        }
        return jsType;
    }
}

