/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.httpjson.OperationSnapshotFactory;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;

@BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
@InternalApi
public class HttpJsonOperationSnapshotCallable<RequestT, OperationT>
extends UnaryCallable<RequestT, OperationSnapshot> {
    private final UnaryCallable<RequestT, OperationT> innerCallable;
    private final OperationSnapshotFactory<RequestT, OperationT> operationSnapshotFactory;

    public HttpJsonOperationSnapshotCallable(UnaryCallable<RequestT, OperationT> innerCallable, OperationSnapshotFactory<RequestT, OperationT> operationSnapshotFactory) {
        this.innerCallable = innerCallable;
        this.operationSnapshotFactory = operationSnapshotFactory;
    }

    @Override
    public ApiFuture<OperationSnapshot> futureCall(final RequestT request, ApiCallContext context) {
        return ApiFutures.transform(this.innerCallable.futureCall(request, context), new ApiFunction<OperationT, OperationSnapshot>(){

            @Override
            public OperationSnapshot apply(OperationT operation) {
                return HttpJsonOperationSnapshotCallable.this.operationSnapshotFactory.create(request, operation);
            }
        }, MoreExecutors.directExecutor());
    }
}

