/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.output.operators;

import java.util.function.Supplier;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.state.api.functions.KeyedStateBootstrapFunction;
import org.apache.flink.state.api.output.SnapshotUtils;
import org.apache.flink.state.api.output.TaggedOperatorSubtaskState;
import org.apache.flink.state.api.output.operators.LazyTimerService;
import org.apache.flink.state.api.runtime.VoidTriggerable;
import org.apache.flink.streaming.api.TimerService;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Preconditions;

@Internal
public class KeyedStateBootstrapOperator<K, IN>
extends AbstractUdfStreamOperator<TaggedOperatorSubtaskState, KeyedStateBootstrapFunction<K, IN>>
implements OneInputStreamOperator<IN, TaggedOperatorSubtaskState>,
BoundedOneInput {
    private static final long serialVersionUID = 1L;
    private final long timestamp;
    private final Path savepointPath;
    private transient ContextImpl context;

    public KeyedStateBootstrapOperator(long timestamp, Path savepointPath, KeyedStateBootstrapFunction<K, IN> function) {
        super(function);
        this.timestamp = timestamp;
        this.savepointPath = savepointPath;
    }

    public void open() throws Exception {
        super.open();
        Supplier<InternalTimerService<VoidNamespace>> internalTimerService = () -> this.getInternalTimerService("user-timers", (TypeSerializer)VoidNamespaceSerializer.INSTANCE, VoidTriggerable.instance());
        LazyTimerService timerService = new LazyTimerService(internalTimerService, this.getProcessingTimeService());
        this.context = new ContextImpl((KeyedStateBootstrapFunction)this.userFunction, timerService);
    }

    public void processElement(StreamRecord<IN> element) throws Exception {
        ((KeyedStateBootstrapFunction)this.userFunction).processElement(element.getValue(), this.context);
    }

    public void endInput() throws Exception {
        TaggedOperatorSubtaskState state = SnapshotUtils.snapshot(this, this.getRuntimeContext().getIndexOfThisSubtask(), this.timestamp, this.getContainingTask().getConfiguration().isExactlyOnceCheckpointMode(), this.getContainingTask().getConfiguration().isUnalignedCheckpointsEnabled(), this.getContainingTask().getConfiguration().getConfiguration(), this.savepointPath);
        this.output.collect((Object)new StreamRecord((Object)state));
    }

    private class ContextImpl
    extends KeyedStateBootstrapFunction.Context {
        private final TimerService timerService;

        ContextImpl(KeyedStateBootstrapFunction<K, IN> function, TimerService timerService) {
            super(function);
            this.timerService = (TimerService)Preconditions.checkNotNull((Object)timerService);
        }

        @Override
        public TimerService timerService() {
            return this.timerService;
        }

        @Override
        public K getCurrentKey() {
            return KeyedStateBootstrapOperator.this.getCurrentKey();
        }
    }
}

