/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3.common;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.EntropyInjectingFileSystem;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.core.fs.RefCountedFileWithStream;
import org.apache.flink.core.fs.RefCountedTmpFileCreator;
import org.apache.flink.fs.s3.common.writer.S3AccessHelper;
import org.apache.flink.fs.s3.common.writer.S3RecoverableWriter;
import org.apache.flink.fs.s3hadoop.common.HadoopFileSystem;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.hadoop.fs.FileSystem;

public class FlinkS3FileSystem
extends HadoopFileSystem
implements EntropyInjectingFileSystem {
    @Nullable
    private final String entropyInjectionKey;
    private final int entropyLength;
    public static final long S3_MULTIPART_MIN_PART_SIZE = 0x500000L;
    private final String localTmpDir;
    private final FunctionWithException<File, RefCountedFileWithStream, IOException> tmpFileCreator;
    @Nullable
    private final S3AccessHelper s3AccessHelper;
    private final Executor uploadThreadPool;
    private final long s3uploadPartSize;
    private final int maxConcurrentUploadsPerStream;

    public FlinkS3FileSystem(FileSystem hadoopS3FileSystem, String localTmpDirectory, @Nullable String entropyInjectionKey, int entropyLength, @Nullable S3AccessHelper s3UploadHelper, long s3uploadPartSize, int maxConcurrentUploadsPerStream) {
        super(hadoopS3FileSystem);
        if (entropyInjectionKey != null && entropyLength <= 0) {
            throw new IllegalArgumentException("Entropy length must be >= 0 when entropy injection key is set");
        }
        this.entropyInjectionKey = entropyInjectionKey;
        this.entropyLength = entropyLength;
        this.localTmpDir = (String)Preconditions.checkNotNull((Object)localTmpDirectory);
        this.tmpFileCreator = RefCountedTmpFileCreator.inDirectories((File[])new File[]{new File(localTmpDirectory)});
        this.s3AccessHelper = s3UploadHelper;
        this.uploadThreadPool = Executors.newCachedThreadPool();
        Preconditions.checkArgument((s3uploadPartSize >= 0x500000L ? 1 : 0) != 0);
        this.s3uploadPartSize = s3uploadPartSize;
        this.maxConcurrentUploadsPerStream = maxConcurrentUploadsPerStream;
    }

    @Nullable
    public String getEntropyInjectionKey() {
        return this.entropyInjectionKey;
    }

    public String generateEntropy() {
        return StringUtils.generateRandomAlphanumericString((Random)ThreadLocalRandom.current(), (int)this.entropyLength);
    }

    @Override
    public FileSystemKind getKind() {
        return FileSystemKind.OBJECT_STORE;
    }

    public String getLocalTmpDir() {
        return this.localTmpDir;
    }

    @Override
    public RecoverableWriter createRecoverableWriter() throws IOException {
        if (this.s3AccessHelper == null) {
            throw new UnsupportedOperationException("This s3 file system implementation does not support recoverable writers.");
        }
        return S3RecoverableWriter.writer(this.getHadoopFileSystem(), this.tmpFileCreator, this.s3AccessHelper, this.uploadThreadPool, this.s3uploadPartSize, this.maxConcurrentUploadsPerStream);
    }
}

