/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.net.InetSocketAddress;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;

public class CliOptions {
    private final boolean isPrintHelp;
    private final String sessionId;
    private final URL initFile;
    private final URL sqlFile;
    private final String updateStatement;
    private final String historyFilePath;

    private CliOptions(boolean isPrintHelp, String sessionId, URL initFile, URL sqlFile, String updateStatement, String historyFilePath) {
        this.isPrintHelp = isPrintHelp;
        this.sessionId = sessionId;
        this.initFile = initFile;
        this.sqlFile = sqlFile;
        this.updateStatement = updateStatement;
        this.historyFilePath = historyFilePath;
    }

    public boolean isPrintHelp() {
        return this.isPrintHelp;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    @Nullable
    public URL getInitFile() {
        return this.initFile;
    }

    @Nullable
    public URL getSqlFile() {
        return this.sqlFile;
    }

    public String getHistoryFilePath() {
        return this.historyFilePath;
    }

    public String getUpdateStatement() {
        return this.updateStatement;
    }

    public static class GatewayCliOptions
    extends CliOptions {
        @Nullable
        private final InetSocketAddress gatewayAddress;

        GatewayCliOptions(boolean isPrintHelp, String sessionId, URL initFile, URL sqlFile, String updateStatement, String historyFilePath, @Nullable InetSocketAddress gatewayAddress) {
            super(isPrintHelp, sessionId, initFile, sqlFile, updateStatement, historyFilePath);
            this.gatewayAddress = gatewayAddress;
        }

        public Optional<InetSocketAddress> getGatewayAddress() {
            return Optional.ofNullable(this.gatewayAddress);
        }
    }

    public static class EmbeddedCliOptions
    extends CliOptions {
        private final List<URL> jars;
        private final List<URL> libraryDirs;
        private final Configuration pythonConfiguration;

        public EmbeddedCliOptions(boolean isPrintHelp, String sessionId, URL initFile, URL sqlFile, String updateStatement, String historyFilePath, List<URL> jars, List<URL> libraryDirs, Configuration pythonConfiguration) {
            super(isPrintHelp, sessionId, initFile, sqlFile, updateStatement, historyFilePath);
            this.jars = jars;
            this.libraryDirs = libraryDirs;
            this.pythonConfiguration = pythonConfiguration;
        }

        public List<URL> getJars() {
            return this.jars;
        }

        public List<URL> getLibraryDirs() {
            return this.libraryDirs;
        }

        public Configuration getPythonConfiguration() {
            return this.pythonConfiguration;
        }
    }
}

