/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.config;

import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.table.client.config.ResultMode;

public class SqlClientOptions {
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH_STREAMING)
    public static final ConfigOption<Integer> EXECUTION_MAX_TABLE_RESULT_ROWS = ConfigOptions.key((String)"sql-client.execution.max-table-result.rows").intType().defaultValue((Object)1000000).withDescription("The number of rows to cache when in the table mode. If the number of rows exceeds the specified value, it retries the row in the FIFO style.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH_STREAMING)
    public static final ConfigOption<ResultMode> EXECUTION_RESULT_MODE = ConfigOptions.key((String)"sql-client.execution.result-mode").enumType(ResultMode.class).defaultValue((Object)ResultMode.TABLE).withDescription("Determines how the query result should be displayed.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH_STREAMING)
    public static final ConfigOption<Boolean> VERBOSE = ConfigOptions.key((String)"sql-client.verbose").booleanType().defaultValue((Object)false).withDescription("Determine whether to output the verbose output to the console. If set the option true, it will print the exception stack. Otherwise, it only output the cause.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.STREAMING)
    public static final ConfigOption<Integer> DISPLAY_MAX_COLUMN_WIDTH = ConfigOptions.key((String)"sql-client.display.max-column-width").intType().defaultValue((Object)30).withDescription("When printing the query results, this parameter determines the number of characters shown on screen before truncating.This only applies to columns with variable-length types (e.g. STRING) in streaming mode.Fixed-length types and all types in batch mode are printed using a deterministic column width");

    private SqlClientOptions() {
    }
}

