/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleOperandChildPolicy;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class RelOptRuleOperand {
    private @Nullable RelOptRuleOperand parent;
    @NotOnlyInitialized
    private RelOptRule rule;
    private final Predicate<RelNode> predicate;
    public int @MonotonicNonNull [] solveOrder;
    public int ordinalInParent;
    public int ordinalInRule;
    public final @Nullable RelTrait trait;
    private final Class<? extends RelNode> clazz;
    private final ImmutableList<RelOptRuleOperand> children;
    public final RelOptRuleOperandChildPolicy childPolicy;

    @Deprecated
    protected <R extends RelNode> RelOptRuleOperand(Class<R> clazz, RelTrait trait, Predicate<? super R> predicate, RelOptRuleOperandChildren children) {
        this(clazz, trait, predicate, children.policy, children.operands);
    }

    <R extends RelNode> RelOptRuleOperand(Class<R> clazz, @Nullable RelTrait trait, Predicate<? super R> predicate, RelOptRuleOperandChildPolicy childPolicy, ImmutableList<RelOptRuleOperand> children) {
        assert (clazz != null);
        switch (childPolicy) {
            case ANY: {
                break;
            }
            case LEAF: {
                assert (children.size() == 0);
                break;
            }
            case UNORDERED: {
                assert (children.size() == 1);
                break;
            }
            default: {
                assert (children.size() > 0);
                break;
            }
        }
        this.childPolicy = childPolicy;
        this.clazz = Objects.requireNonNull(clazz, "clazz");
        this.trait = trait;
        this.predicate = Objects.requireNonNull(predicate);
        this.children = children;
        for (RelOptRuleOperand child : this.children) {
            assert (child.parent == null) : "cannot re-use operands";
            child.parent = this;
        }
    }

    public @Nullable RelOptRuleOperand getParent() {
        return this.parent;
    }

    public void setParent(@Nullable RelOptRuleOperand parent) {
        this.parent = parent;
    }

    public RelOptRule getRule() {
        return this.rule;
    }

    public void setRule(@UnknownInitialization RelOptRule rule) {
        this.rule = rule;
    }

    public int hashCode() {
        return Objects.hash(this.clazz, this.trait, this.children);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RelOptRuleOperand)) {
            return false;
        }
        RelOptRuleOperand that = (RelOptRuleOperand)obj;
        return this.clazz == that.clazz && Objects.equals(this.trait, that.trait) && this.children.equals(that.children);
    }

    public String toString() {
        RelOptRuleOperand root = this;
        while (root.parent != null) {
            root = root.parent;
        }
        StringBuilder s2 = root.describeIt(this);
        return s2.toString();
    }

    private StringBuilder describeIt(RelOptRuleOperand that) {
        StringBuilder s2 = new StringBuilder();
        if (this.parent == null) {
            s2.append(this.rule).append(": ");
        }
        if (this == that) {
            s2.append('*');
        }
        s2.append(this.clazz.getSimpleName());
        if (this == that) {
            s2.append('*');
        }
        if (this.children != null && !this.children.isEmpty()) {
            s2.append('(');
            boolean first = true;
            for (RelOptRuleOperand child : this.children) {
                if (!first) {
                    s2.append(", ");
                }
                s2.append((CharSequence)child.describeIt(that));
                first = false;
            }
            s2.append(')');
        }
        return s2;
    }

    public Class<? extends RelNode> getMatchedClass() {
        return this.clazz;
    }

    public List<RelOptRuleOperand> getChildOperands() {
        return this.children;
    }

    public boolean matches(RelNode rel) {
        if (!this.clazz.isInstance(rel)) {
            return false;
        }
        if (this.trait != null && !rel.getTraitSet().contains(this.trait)) {
            return false;
        }
        return this.predicate.test(rel);
    }
}

