/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.ExtendedOperationExecutor;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.delegation.PlannerContext;

@Internal
public interface DialectFactory
extends Factory {
    public Parser create(Context var1);

    default public ExtendedOperationExecutor createExtendedOperationExecutor(Context context) {
        return new EmptyOperationExecutor();
    }

    public static class EmptyOperationExecutor
    implements ExtendedOperationExecutor {
        public Optional<TableResultInternal> executeOperation(Operation operation) {
            return Optional.empty();
        }
    }

    public static class DefaultParserContext
    implements Context {
        private final CatalogManager catalogManager;
        private final PlannerContext plannerContext;
        private final Executor executor;

        public DefaultParserContext(CatalogManager catalogManager, PlannerContext plannerContext, Executor executor) {
            this.catalogManager = catalogManager;
            this.plannerContext = plannerContext;
            this.executor = executor;
        }

        @Override
        public CatalogManager getCatalogManager() {
            return this.catalogManager;
        }

        @Override
        public PlannerContext getPlannerContext() {
            return this.plannerContext;
        }

        @Override
        public Executor getExecutor() {
            return this.executor;
        }
    }

    public static interface Context {
        public CatalogManager getCatalogManager();

        public PlannerContext getPlannerContext();

        public Executor getExecutor();
    }
}

