/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.planner.codegen.CodeGenUtils;
import org.apache.flink.table.planner.functions.casting.AbstractCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastCodeBlock;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;

abstract class AbstractNullAwareCodeGeneratorCastRule<IN, OUT>
extends AbstractCodeGeneratorCastRule<IN, OUT> {
    protected AbstractNullAwareCodeGeneratorCastRule(CastRulePredicate predicate) {
        super(predicate);
    }

    protected abstract String generateCodeBlockInternal(CodeGeneratorCastRule.Context var1, String var2, String var3, LogicalType var4, LogicalType var5);

    @Override
    public CastCodeBlock generateCodeBlock(CodeGeneratorCastRule.Context context, String inputTerm, String inputIsNullTerm, LogicalType inputType, LogicalType targetType) {
        String nullTerm;
        boolean isResultNullable;
        CastRuleUtils.CodeWriter writer = new CastRuleUtils.CodeWriter();
        boolean bl = isResultNullable = inputType.isNullable() || CodeGenUtils.isPrimitiveNullable(targetType);
        if (isResultNullable) {
            nullTerm = context.declareVariable("boolean", "isNull");
            writer.assignStmt(nullTerm, inputIsNullTerm);
        } else {
            nullTerm = "false";
        }
        String returnTerm = context.declareVariable(CodeGenUtils.primitiveTypeTermForType(targetType), "result");
        String castCodeBlock = this.generateCodeBlockInternal(context, inputTerm, returnTerm, inputType, targetType);
        if (isResultNullable) {
            writer.ifStmt("!" + nullTerm, thenWriter -> {
                thenWriter.appendBlock(castCodeBlock);
                if (CodeGenUtils.isPrimitiveNullable(targetType)) {
                    thenWriter.assignStmt(nullTerm, returnTerm + " == null");
                }
            }, elseWriter -> elseWriter.assignStmt(returnTerm, CodeGenUtils.primitiveDefaultValue(targetType)));
        } else {
            writer.appendBlock(castCodeBlock);
        }
        return CastCodeBlock.withCode(writer.toString(), returnTerm, nullTerm);
    }
}

