/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.windowing.util;

import java.util.Arrays;
import java.util.Random;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.watermark.Watermark;

public class CarSource
implements SourceFunction<Tuple4<Integer, Integer, Double, Long>> {
    private static final long serialVersionUID = 1L;
    private Integer[] speeds;
    private Double[] distances;
    private Random rand = new Random();
    private volatile boolean isRunning = true;

    private CarSource(int numOfCars) {
        this.speeds = new Integer[numOfCars];
        this.distances = new Double[numOfCars];
        Arrays.fill((Object[])this.speeds, (Object)50);
        Arrays.fill((Object[])this.distances, (Object)0.0);
    }

    public static CarSource create(int cars) {
        return new CarSource(cars);
    }

    public void run(SourceFunction.SourceContext<Tuple4<Integer, Integer, Double, Long>> ctx) throws Exception {
        while (this.isRunning) {
            Thread.sleep(100L);
            for (int carId = 0; carId < this.speeds.length; ++carId) {
                this.speeds[carId] = this.rand.nextBoolean() ? Integer.valueOf(Math.min(100, this.speeds[carId] + 5)) : Integer.valueOf(Math.max(0, this.speeds[carId] - 5));
                Double[] doubleArray = this.distances;
                int n = carId;
                Double.valueOf(doubleArray[n] + (double)this.speeds[carId].intValue() / 3.6);
                Tuple4 record = new Tuple4((Object)carId, (Object)this.speeds[carId], (Object)this.distances[carId], (Object)System.currentTimeMillis());
                ctx.collectWithTimestamp((Object)record, ((Long)record.f3).longValue());
            }
            ctx.emitWatermark(new Watermark(System.currentTimeMillis()));
        }
    }

    public void cancel() {
        this.isRunning = false;
    }
}

