/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.cli.CliOptions;
import org.apache.flink.table.gateway.service.context.DefaultContext;
import org.apache.flink.util.JarUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultContextUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultContextUtils.class);

    public static DefaultContext buildDefaultContext(CliOptions.EmbeddedCliOptions options) {
        List<URL> jars = options.getJars() != null ? options.getJars() : Collections.emptyList();
        List<URL> libDirs = options.getLibraryDirs() != null ? options.getLibraryDirs() : Collections.emptyList();
        return DefaultContext.load((Configuration)options.getPythonConfiguration(), DefaultContextUtils.discoverDependencies(jars, libDirs), (boolean)true, (boolean)true);
    }

    public static DefaultContext buildDefaultContext(CliOptions.GatewayCliOptions options) {
        return DefaultContext.load((Configuration)new Configuration(), Collections.emptyList(), (boolean)false, (boolean)false);
    }

    private static List<URL> discoverDependencies(List<URL> jars, List<URL> libraries) {
        ArrayList<URL> dependencies = new ArrayList<URL>();
        try {
            for (URL url : jars) {
                JarUtils.checkJarFile((URL)url);
                dependencies.add(url);
            }
            for (URL libUrl : libraries) {
                File dir = new File(libUrl.toURI());
                if (!dir.isDirectory()) {
                    throw new SqlClientException("Directory expected: " + dir);
                }
                if (!dir.canRead()) {
                    throw new SqlClientException("Directory cannot be read: " + dir);
                }
                File[] files = dir.listFiles();
                if (files == null) {
                    throw new SqlClientException("Directory cannot be read: " + dir);
                }
                for (File f : files) {
                    if (!f.isFile() || !f.getAbsolutePath().toLowerCase().endsWith(".jar")) continue;
                    URL url = f.toURI().toURL();
                    JarUtils.checkJarFile((URL)url);
                    dependencies.add(url);
                }
            }
        }
        catch (Exception e) {
            throw new SqlClientException("Could not load all required JAR files.", e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using the following dependencies: {}", dependencies);
        }
        return dependencies;
    }
}

