/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.sink.writer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.base.sink.writer.RequestBuffer;
import org.apache.flink.connector.base.sink.writer.RequestEntryWrapper;

@PublicEvolving
public class BufferedRequestState<RequestEntryT extends Serializable>
implements Serializable {
    private final List<RequestEntryWrapper<RequestEntryT>> bufferedRequestEntries;
    private final long stateSize;

    @Deprecated
    public BufferedRequestState(Deque<RequestEntryWrapper<RequestEntryT>> bufferedRequestEntries) {
        this.bufferedRequestEntries = new ArrayList<RequestEntryWrapper<RequestEntryT>>(bufferedRequestEntries);
        this.stateSize = this.calculateStateSize();
    }

    public BufferedRequestState(List<RequestEntryWrapper<RequestEntryT>> bufferedRequestEntries) {
        this.bufferedRequestEntries = new ArrayList<RequestEntryWrapper<RequestEntryT>>(bufferedRequestEntries);
        this.stateSize = this.calculateStateSize();
    }

    public BufferedRequestState(RequestBuffer<RequestEntryT> requestBuffer) {
        this.bufferedRequestEntries = new ArrayList<RequestEntryWrapper<RequestEntryT>>(requestBuffer.getBufferedState());
        this.stateSize = this.calculateStateSize();
    }

    public List<RequestEntryWrapper<RequestEntryT>> getBufferedRequestEntries() {
        return this.bufferedRequestEntries;
    }

    public long getStateSize() {
        return this.stateSize;
    }

    private long calculateStateSize() {
        long stateSize = 0L;
        for (RequestEntryWrapper<RequestEntryT> requestEntryWrapper : this.bufferedRequestEntries) {
            stateSize += requestEntryWrapper.getSize();
        }
        return stateSize;
    }

    public static <T extends Serializable> BufferedRequestState<T> emptyState() {
        return new BufferedRequestState(Collections.emptyList());
    }
}

