/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.dataview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.dataview.DataView;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.dataview.NullSerializer;
import org.apache.flink.table.runtime.dataview.DataViewSpec;
import org.apache.flink.table.runtime.dataview.ListViewSpec;
import org.apache.flink.table.runtime.dataview.MapViewSpec;
import org.apache.flink.table.runtime.typeutils.ExternalSerializer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeTransformation;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public final class DataViewUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isDataView(LogicalType viewType, Class<? extends DataView> viewClass) {
        if (!viewType.is(LogicalTypeRoot.STRUCTURED_TYPE)) return false;
        if (((StructuredType)viewType).getImplementationClass().map(viewClass::isAssignableFrom).orElse(false) == false) return false;
        boolean bl = true;
        boolean isDataView = bl;
        if (!isDataView) {
            return false;
        }
        viewType.getChildren().forEach(DataViewUtils::checkForInvalidDataViews);
        return true;
    }

    public static void checkForInvalidDataViews(LogicalType type) {
        if (LogicalTypeChecks.hasNested((LogicalType)type, t -> DataViewUtils.isDataView(t, DataView.class))) {
            throw new ValidationException("Data views are not supported at the declared location. Given type: " + String.valueOf(type));
        }
    }

    public static List<DataViewSpec> extractDataViews(int aggIndex, DataType accumulatorDataType) {
        LogicalType accumulatorType = accumulatorDataType.getLogicalType();
        if (!accumulatorType.is(LogicalTypeRoot.ROW) && !accumulatorType.is(LogicalTypeRoot.STRUCTURED_TYPE)) {
            return Collections.emptyList();
        }
        List fieldNames = LogicalTypeChecks.getFieldNames((LogicalType)accumulatorType);
        List fieldDataTypes = accumulatorDataType.getChildren();
        ArrayList<DataViewSpec> specs = new ArrayList<DataViewSpec>();
        for (int fieldIndex = 0; fieldIndex < fieldDataTypes.size(); ++fieldIndex) {
            DataType fieldDataType = (DataType)fieldDataTypes.get(fieldIndex);
            LogicalType fieldType = fieldDataType.getLogicalType();
            if (DataViewUtils.isDataView(fieldType, ListView.class)) {
                specs.add(new ListViewSpec(DataViewUtils.createStateId(aggIndex, (String)fieldNames.get(fieldIndex)), fieldIndex, (DataType)fieldDataType.getChildren().get(0)));
                continue;
            }
            if (!DataViewUtils.isDataView(fieldType, MapView.class)) continue;
            specs.add(new MapViewSpec(DataViewUtils.createStateId(aggIndex, (String)fieldNames.get(fieldIndex)), fieldIndex, (DataType)fieldDataType.getChildren().get(0), false));
        }
        return specs;
    }

    public static DataType adjustDataViews(DataType accumulatorDataType, boolean hasStateBackedDataViews) {
        Function<DataType, Object> serializer = hasStateBackedDataViews ? dataType -> NullSerializer.INSTANCE : ExternalSerializer::of;
        return DataTypeUtils.transform((DataType)accumulatorDataType, (TypeTransformation[])new TypeTransformation[]{new DataViewsTransformation(serializer)});
    }

    public static DataType createDistinctViewDataType(DataType keyDataType, int filterArgs, int filterArgsLimit) {
        DataType valueDataType = filterArgs <= filterArgsLimit ? (DataType)DataTypes.BIGINT().notNull() : (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.BIGINT().notNull())).bridgedTo(long[].class);
        return MapView.newMapViewDataType((DataType)keyDataType, (DataType)valueDataType);
    }

    public static DistinctViewSpec createDistinctViewSpec(int index, DataType distinctViewDataType) {
        return new DistinctViewSpec("distinctAcc_" + index, distinctViewDataType);
    }

    private static String createStateId(int fieldIndex, String fieldName) {
        return "agg" + fieldIndex + "$" + fieldName;
    }

    private DataViewUtils() {
    }

    public static class DistinctViewSpec
    extends MapViewSpec {
        public DistinctViewSpec(String stateId, DataType distinctViewDataType) {
            super(stateId, -1, (DataType)distinctViewDataType.getChildren().get(0), true);
        }
    }

    private static class DataViewsTransformation
    implements TypeTransformation {
        private final Function<DataType, TypeSerializer<?>> serializer;

        private DataViewsTransformation(Function<DataType, TypeSerializer<?>> serializer) {
            this.serializer = serializer;
        }

        public DataType transform(DataType dataType) {
            if (DataViewUtils.isDataView(dataType.getLogicalType(), DataView.class)) {
                return DataTypes.RAW((Class)dataType.getConversionClass(), this.serializer.apply(dataType));
            }
            return dataType;
        }
    }
}

