/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.memory;

import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.runtime.util.MemorySegmentPool;
import org.apache.flink.table.store.file.memory.MemoryOwner;

public class MemoryPoolFactory {
    private final MemorySegmentPool innerPool;
    private final int totalPages;
    private final Iterable<MemoryOwner> owners;

    public MemoryPoolFactory(MemorySegmentPool innerPool, Iterable<MemoryOwner> owners) {
        this.innerPool = innerPool;
        this.totalPages = innerPool.freePages();
        this.owners = owners;
    }

    public void notifyNewOwner(MemoryOwner owner) {
        owner.setMemoryPool(this.createSubPool(owner));
    }

    MemorySegmentPool createSubPool(MemoryOwner owner) {
        return new OwnerMemoryPool(owner);
    }

    private void preemptMemory(MemoryOwner owner) {
        long maxMemory = -1L;
        MemoryOwner max = null;
        for (MemoryOwner other : this.owners) {
            if (other == owner || other.memoryOccupancy() <= maxMemory) continue;
            maxMemory = other.memoryOccupancy();
            max = other;
        }
        if (max != null) {
            try {
                max.flushMemory();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class OwnerMemoryPool
    implements MemorySegmentPool {
        private final MemoryOwner owner;
        private int allocatedPages = 0;

        public OwnerMemoryPool(MemoryOwner owner) {
            this.owner = owner;
        }

        public int pageSize() {
            return MemoryPoolFactory.this.innerPool.pageSize();
        }

        public void returnAll(List<MemorySegment> memory) {
            this.allocatedPages -= memory.size();
            MemoryPoolFactory.this.innerPool.returnAll(memory);
        }

        public int freePages() {
            return MemoryPoolFactory.this.totalPages - this.allocatedPages;
        }

        public MemorySegment nextSegment() {
            MemorySegment segment = MemoryPoolFactory.this.innerPool.nextSegment();
            if (segment == null) {
                MemoryPoolFactory.this.preemptMemory(this.owner);
                segment = MemoryPoolFactory.this.innerPool.nextSegment();
            }
            if (segment != null) {
                ++this.allocatedPages;
            }
            return segment;
        }
    }
}

