/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.sink;

import java.util.Objects;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.file.io.CompactIncrement;
import org.apache.flink.table.store.file.io.NewFilesIncrement;

public class FileCommittable {
    private final BinaryRowData partition;
    private final int bucket;
    private final NewFilesIncrement newFilesIncrement;
    private final CompactIncrement compactIncrement;

    public FileCommittable(BinaryRowData partition, int bucket, NewFilesIncrement newFilesIncrement, CompactIncrement compactIncrement) {
        this.partition = partition;
        this.bucket = bucket;
        this.newFilesIncrement = newFilesIncrement;
        this.compactIncrement = compactIncrement;
    }

    public BinaryRowData partition() {
        return this.partition;
    }

    public int bucket() {
        return this.bucket;
    }

    public NewFilesIncrement newFilesIncrement() {
        return this.newFilesIncrement;
    }

    public CompactIncrement compactIncrement() {
        return this.compactIncrement;
    }

    public boolean isEmpty() {
        return this.newFilesIncrement.isEmpty() && this.compactIncrement.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileCommittable that = (FileCommittable)o;
        return this.bucket == that.bucket && Objects.equals(this.partition, that.partition) && Objects.equals(this.newFilesIncrement, that.newFilesIncrement) && Objects.equals(this.compactIncrement, that.compactIncrement);
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.bucket, this.newFilesIncrement, this.compactIncrement);
    }

    public String toString() {
        return String.format("FileCommittable {partition = %s, bucket = %d, newFilesIncrement = %s, compactIncrement = %s}", this.partition, this.bucket, this.newFilesIncrement, this.compactIncrement);
    }
}

