/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.util.Preconditions;

public class BlockingResultInfo {
    private final List<Long> blockingPartitionSizes;
    private final boolean isBroadcast;

    private BlockingResultInfo(List<Long> blockingPartitionSizes, boolean isBroadcast) {
        this.blockingPartitionSizes = blockingPartitionSizes;
        this.isBroadcast = isBroadcast;
    }

    public List<Long> getBlockingPartitionSizes() {
        return this.blockingPartitionSizes;
    }

    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    @VisibleForTesting
    static BlockingResultInfo createFromBroadcastResult(List<Long> blockingPartitionSizes) {
        return new BlockingResultInfo(blockingPartitionSizes, true);
    }

    @VisibleForTesting
    static BlockingResultInfo createFromNonBroadcastResult(List<Long> blockingPartitionSizes) {
        return new BlockingResultInfo(blockingPartitionSizes, false);
    }

    public static BlockingResultInfo createFromIntermediateResult(IntermediateResult intermediateResult) {
        Preconditions.checkArgument(intermediateResult != null);
        ArrayList<Long> blockingPartitionSizes = new ArrayList<Long>();
        for (IntermediateResultPartition partition : intermediateResult.getPartitions()) {
            Preconditions.checkState(partition.isConsumable());
            IOMetrics ioMetrics = partition.getProducer().getPartitionProducer().getIOMetrics();
            Preconditions.checkNotNull(ioMetrics, "IOMetrics should not be null.");
            blockingPartitionSizes.add(ioMetrics.getNumBytesProducedOfPartitions().get(partition.getPartitionId()));
        }
        return new BlockingResultInfo(blockingPartitionSizes, intermediateResult.isBroadcast());
    }
}

