/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.security.NoMatchSecurityFactoryException;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityContextInitializeException;
import org.apache.flink.runtime.security.SecurityFactoryServiceLoader;
import org.apache.flink.runtime.security.contexts.NoOpSecurityContext;
import org.apache.flink.runtime.security.contexts.SecurityContext;
import org.apache.flink.runtime.security.contexts.SecurityContextFactory;
import org.apache.flink.runtime.security.modules.SecurityModule;
import org.apache.flink.runtime.security.modules.SecurityModuleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtils.class);
    private static SecurityContext installedContext = new NoOpSecurityContext();
    private static List<SecurityModule> installedModules = null;

    public static SecurityContext getInstalledContext() {
        return installedContext;
    }

    public static List<SecurityModule> getInstalledModules() {
        return installedModules;
    }

    public static void install(SecurityConfiguration config) throws Exception {
        SecurityUtils.installModules(config);
        SecurityUtils.installContext(config);
    }

    static void installModules(SecurityConfiguration config) throws Exception {
        ArrayList<SecurityModule> modules = new ArrayList<SecurityModule>();
        for (String moduleFactoryClass : config.getSecurityModuleFactories()) {
            SecurityModuleFactory moduleFactory = null;
            try {
                moduleFactory = SecurityFactoryServiceLoader.findModuleFactory(moduleFactoryClass);
            }
            catch (NoMatchSecurityFactoryException ne) {
                LOG.error("Unable to instantiate security module factory {}", (Object)moduleFactoryClass);
                throw new IllegalArgumentException("Unable to find module factory class", ne);
            }
            SecurityModule module = moduleFactory.createModule(config);
            if (module == null) continue;
            module.install();
            modules.add(module);
        }
        installedModules = modules;
    }

    static void installContext(SecurityConfiguration config) throws Exception {
        for (String contextFactoryClass : config.getSecurityContextFactories()) {
            try {
                SecurityContextFactory contextFactory = SecurityFactoryServiceLoader.findContextFactory(contextFactoryClass);
                if (contextFactory.isCompatibleWith(config)) {
                    try {
                        installedContext = contextFactory.createContext(config);
                        break;
                    }
                    catch (SecurityContextInitializeException e) {
                        LOG.error("Cannot instantiate security context with: " + contextFactoryClass, (Throwable)e);
                        continue;
                    }
                    catch (LinkageError le) {
                        LOG.error("Error occur when instantiate security context with: " + contextFactoryClass, (Throwable)le);
                        continue;
                    }
                }
                LOG.debug("Unable to install security context factory {}", (Object)contextFactoryClass);
            }
            catch (NoMatchSecurityFactoryException ne) {
                LOG.warn("Unable to instantiate security context factory {}", (Object)contextFactoryClass);
            }
        }
        if (installedContext == null) {
            LOG.error("Unable to install a valid security context factory!");
            throw new Exception("Unable to install a valid security context factory!");
        }
    }

    static void uninstall() {
        if (installedModules != null) {
            for (int i = installedModules.size() - 1; i >= 0; --i) {
                SecurityModule module = installedModules.get(i);
                try {
                    module.uninstall();
                    continue;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    continue;
                }
                catch (SecurityModule.SecurityInstallException e) {
                    LOG.warn("unable to uninstall a security module", (Throwable)e);
                }
            }
            installedModules = null;
        }
        installedContext = new NoOpSecurityContext();
    }
}

