/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.state.CheckpointListener;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketFactory;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.Buckets;
import org.apache.flink.streaming.api.functions.sink.filesystem.BulkBucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.DefaultBucketFactoryImpl;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputFileConfig;
import org.apache.flink.streaming.api.functions.sink.filesystem.RollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.RowWiseBucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.StreamingFileSinkHelper;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.DateTimeBucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.CheckpointRollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.DefaultRollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.OnCheckpointRollingPolicy;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.util.Preconditions;

@Deprecated
@PublicEvolving
public class StreamingFileSink<IN>
extends RichSinkFunction<IN>
implements CheckpointedFunction,
CheckpointListener {
    private static final long serialVersionUID = 1L;
    private final long bucketCheckInterval;
    private final BucketsBuilder<IN, ?, ? extends BucketsBuilder<IN, ?, ?>> bucketsBuilder;
    private transient StreamingFileSinkHelper<IN> helper;

    protected StreamingFileSink(BucketsBuilder<IN, ?, ? extends BucketsBuilder<IN, ?, ?>> bucketsBuilder, long bucketCheckInterval) {
        Preconditions.checkArgument(bucketCheckInterval > 0L);
        this.bucketsBuilder = Preconditions.checkNotNull(bucketsBuilder);
        this.bucketCheckInterval = bucketCheckInterval;
    }

    public static <IN> DefaultRowFormatBuilder<IN> forRowFormat(Path basePath, Encoder<IN> encoder) {
        return new DefaultRowFormatBuilder(basePath, encoder, (BucketAssigner)new DateTimeBucketAssigner());
    }

    public static <IN> DefaultBulkFormatBuilder<IN> forBulkFormat(Path basePath, BulkWriter.Factory<IN> writerFactory) {
        return new DefaultBulkFormatBuilder(basePath, writerFactory, (BucketAssigner)new DateTimeBucketAssigner());
    }

    @Override
    public void initializeState(FunctionInitializationContext context) throws Exception {
        this.helper = new StreamingFileSinkHelper<IN>(this.bucketsBuilder.createBuckets(this.getRuntimeContext().getIndexOfThisSubtask()), context.isRestored(), context.getOperatorStateStore(), ((StreamingRuntimeContext)this.getRuntimeContext()).getProcessingTimeService(), this.bucketCheckInterval);
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        this.helper.commitUpToCheckpoint(checkpointId);
    }

    @Override
    public void notifyCheckpointAborted(long checkpointId) {
    }

    @Override
    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        Preconditions.checkState(this.helper != null, "sink has not been initialized");
        this.helper.snapshotState(context.getCheckpointId());
    }

    @Override
    public void invoke(IN value, SinkFunction.Context context) throws Exception {
        this.helper.onElement(value, context.currentProcessingTime(), context.timestamp(), context.currentWatermark());
    }

    @Override
    public void close() throws Exception {
        if (this.helper != null) {
            this.helper.close();
        }
    }

    public static final class DefaultBulkFormatBuilder<IN>
    extends BulkFormatBuilder<IN, String, DefaultBulkFormatBuilder<IN>> {
        private static final long serialVersionUID = 7493169281036370228L;

        private DefaultBulkFormatBuilder(Path basePath, BulkWriter.Factory<IN> writerFactory, BucketAssigner<IN, String> assigner) {
            super(basePath, writerFactory, assigner);
        }
    }

    @PublicEvolving
    public static class BulkFormatBuilder<IN, BucketID, T extends BulkFormatBuilder<IN, BucketID, T>>
    extends BucketsBuilder<IN, BucketID, T> {
        private static final long serialVersionUID = 1L;
        private long bucketCheckInterval;
        private final Path basePath;
        private BulkWriter.Factory<IN> writerFactory;
        private BucketAssigner<IN, BucketID> bucketAssigner;
        private CheckpointRollingPolicy<IN, BucketID> rollingPolicy;
        private BucketFactory<IN, BucketID> bucketFactory;
        private OutputFileConfig outputFileConfig;

        protected BulkFormatBuilder(Path basePath, BulkWriter.Factory<IN> writerFactory, BucketAssigner<IN, BucketID> assigner) {
            this(basePath, writerFactory, assigner, (CheckpointRollingPolicy<IN, BucketID>)OnCheckpointRollingPolicy.build(), 60000L, new DefaultBucketFactoryImpl(), OutputFileConfig.builder().build());
        }

        protected BulkFormatBuilder(Path basePath, BulkWriter.Factory<IN> writerFactory, BucketAssigner<IN, BucketID> assigner, CheckpointRollingPolicy<IN, BucketID> policy, long bucketCheckInterval, BucketFactory<IN, BucketID> bucketFactory, OutputFileConfig outputFileConfig) {
            this.basePath = Preconditions.checkNotNull(basePath);
            this.writerFactory = writerFactory;
            this.bucketAssigner = Preconditions.checkNotNull(assigner);
            this.rollingPolicy = Preconditions.checkNotNull(policy);
            this.bucketCheckInterval = bucketCheckInterval;
            this.bucketFactory = Preconditions.checkNotNull(bucketFactory);
            this.outputFileConfig = Preconditions.checkNotNull(outputFileConfig);
        }

        public long getBucketCheckInterval() {
            return this.bucketCheckInterval;
        }

        public T withBucketCheckInterval(long interval) {
            this.bucketCheckInterval = interval;
            return (T)((BulkFormatBuilder)this.self());
        }

        public T withBucketAssigner(BucketAssigner<IN, BucketID> assigner) {
            this.bucketAssigner = Preconditions.checkNotNull(assigner);
            return (T)((BulkFormatBuilder)this.self());
        }

        public T withRollingPolicy(CheckpointRollingPolicy<IN, BucketID> rollingPolicy) {
            this.rollingPolicy = Preconditions.checkNotNull(rollingPolicy);
            return (T)((BulkFormatBuilder)this.self());
        }

        @VisibleForTesting
        T withBucketFactory(BucketFactory<IN, BucketID> factory) {
            this.bucketFactory = Preconditions.checkNotNull(factory);
            return (T)((BulkFormatBuilder)this.self());
        }

        public T withOutputFileConfig(OutputFileConfig outputFileConfig) {
            this.outputFileConfig = outputFileConfig;
            return (T)((BulkFormatBuilder)this.self());
        }

        public <ID> BulkFormatBuilder<IN, ID, ? extends BulkFormatBuilder<IN, ID, ?>> withNewBucketAssigner(BucketAssigner<IN, ID> assigner) {
            Preconditions.checkState(this.bucketFactory.getClass() == DefaultBucketFactoryImpl.class, "newBuilderWithBucketAssigner() cannot be called after specifying a customized bucket factory");
            return new BulkFormatBuilder<IN, ID, T>(this.basePath, this.writerFactory, Preconditions.checkNotNull(assigner), this.rollingPolicy, this.bucketCheckInterval, new DefaultBucketFactoryImpl(), this.outputFileConfig);
        }

        public StreamingFileSink<IN> build() {
            return new StreamingFileSink(this, this.bucketCheckInterval);
        }

        @Override
        @Internal
        public BucketWriter<IN, BucketID> createBucketWriter() throws IOException {
            return new BulkBucketWriter(FileSystem.get(this.basePath.toUri()).createRecoverableWriter(), this.writerFactory);
        }

        @Override
        @Internal
        public Buckets<IN, BucketID> createBuckets(int subtaskIndex) throws IOException {
            return new Buckets<IN, BucketID>(this.basePath, this.bucketAssigner, this.bucketFactory, this.createBucketWriter(), this.rollingPolicy, subtaskIndex, this.outputFileConfig);
        }
    }

    public static final class DefaultRowFormatBuilder<IN>
    extends RowFormatBuilder<IN, String, DefaultRowFormatBuilder<IN>> {
        private static final long serialVersionUID = -8503344257202146718L;

        private DefaultRowFormatBuilder(Path basePath, Encoder<IN> encoder, BucketAssigner<IN, String> bucketAssigner) {
            super(basePath, encoder, bucketAssigner);
        }
    }

    @PublicEvolving
    public static class RowFormatBuilder<IN, BucketID, T extends RowFormatBuilder<IN, BucketID, T>>
    extends BucketsBuilder<IN, BucketID, T> {
        private static final long serialVersionUID = 1L;
        private long bucketCheckInterval;
        private final Path basePath;
        private Encoder<IN> encoder;
        private BucketAssigner<IN, BucketID> bucketAssigner;
        private RollingPolicy<IN, BucketID> rollingPolicy;
        private BucketFactory<IN, BucketID> bucketFactory;
        private OutputFileConfig outputFileConfig;

        protected RowFormatBuilder(Path basePath, Encoder<IN> encoder, BucketAssigner<IN, BucketID> bucketAssigner) {
            this(basePath, encoder, bucketAssigner, (RollingPolicy<IN, BucketID>)DefaultRollingPolicy.builder().build(), 60000L, new DefaultBucketFactoryImpl(), OutputFileConfig.builder().build());
        }

        protected RowFormatBuilder(Path basePath, Encoder<IN> encoder, BucketAssigner<IN, BucketID> assigner, RollingPolicy<IN, BucketID> policy, long bucketCheckInterval, BucketFactory<IN, BucketID> bucketFactory, OutputFileConfig outputFileConfig) {
            this.basePath = Preconditions.checkNotNull(basePath);
            this.encoder = Preconditions.checkNotNull(encoder);
            this.bucketAssigner = Preconditions.checkNotNull(assigner);
            this.rollingPolicy = Preconditions.checkNotNull(policy);
            this.bucketCheckInterval = bucketCheckInterval;
            this.bucketFactory = Preconditions.checkNotNull(bucketFactory);
            this.outputFileConfig = Preconditions.checkNotNull(outputFileConfig);
        }

        public long getBucketCheckInterval() {
            return this.bucketCheckInterval;
        }

        public T withBucketCheckInterval(long interval) {
            this.bucketCheckInterval = interval;
            return (T)((RowFormatBuilder)this.self());
        }

        public T withBucketAssigner(BucketAssigner<IN, BucketID> assigner) {
            this.bucketAssigner = Preconditions.checkNotNull(assigner);
            return (T)((RowFormatBuilder)this.self());
        }

        public T withRollingPolicy(RollingPolicy<IN, BucketID> policy) {
            this.rollingPolicy = Preconditions.checkNotNull(policy);
            return (T)((RowFormatBuilder)this.self());
        }

        public T withOutputFileConfig(OutputFileConfig outputFileConfig) {
            this.outputFileConfig = outputFileConfig;
            return (T)((RowFormatBuilder)this.self());
        }

        public <ID> RowFormatBuilder<IN, ID, ? extends RowFormatBuilder<IN, ID, ?>> withNewBucketAssignerAndPolicy(BucketAssigner<IN, ID> assigner, RollingPolicy<IN, ID> policy) {
            Preconditions.checkState(this.bucketFactory.getClass() == DefaultBucketFactoryImpl.class, "newBuilderWithBucketAssignerAndPolicy() cannot be called after specifying a customized bucket factory");
            return new RowFormatBuilder<IN, ID, T>(this.basePath, this.encoder, Preconditions.checkNotNull(assigner), Preconditions.checkNotNull(policy), this.bucketCheckInterval, new DefaultBucketFactoryImpl(), this.outputFileConfig);
        }

        public StreamingFileSink<IN> build() {
            return new StreamingFileSink(this, this.bucketCheckInterval);
        }

        @VisibleForTesting
        T withBucketFactory(BucketFactory<IN, BucketID> factory) {
            this.bucketFactory = Preconditions.checkNotNull(factory);
            return (T)((RowFormatBuilder)this.self());
        }

        @Override
        @Internal
        public BucketWriter<IN, BucketID> createBucketWriter() throws IOException {
            return new RowWiseBucketWriter(FileSystem.get(this.basePath.toUri()).createRecoverableWriter(), this.encoder);
        }

        @Override
        @Internal
        public Buckets<IN, BucketID> createBuckets(int subtaskIndex) throws IOException {
            return new Buckets<IN, BucketID>(this.basePath, this.bucketAssigner, this.bucketFactory, this.createBucketWriter(), this.rollingPolicy, subtaskIndex, this.outputFileConfig);
        }
    }

    @Internal
    public static abstract class BucketsBuilder<IN, BucketID, T extends BucketsBuilder<IN, BucketID, T>>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final long DEFAULT_BUCKET_CHECK_INTERVAL = 60000L;

        protected T self() {
            return (T)this;
        }

        @Internal
        public abstract BucketWriter<IN, BucketID> createBucketWriter() throws IOException;

        @Internal
        public abstract Buckets<IN, BucketID> createBuckets(int var1) throws IOException;
    }
}

