/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Random;
import org.apache.flink.annotation.Public;
import org.apache.flink.util.MathUtils;

@Public
public class XORShiftRandom
extends Random {
    private static final long serialVersionUID = -825722456120842841L;
    private long seed;

    public XORShiftRandom() {
        this(System.nanoTime());
    }

    public XORShiftRandom(long input) {
        super(input);
        this.seed = MathUtils.murmurHash((int)input) ^ MathUtils.murmurHash((int)(input >>> 32));
    }

    @Override
    public int next(int bits) {
        long nextSeed = this.seed ^ this.seed << 21;
        nextSeed ^= nextSeed >>> 35;
        nextSeed ^= nextSeed << 4;
        this.seed = nextSeed;
        return (int)(nextSeed & (1L << bits) - 1L);
    }
}

