/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package org.apache.geode.tools.pulse.tests.ui;

public class PulseTestConstants {
  public static final String DATA_VIEW_LABEL = "Data View";
  public static final String CLUSTER_VIEW_MEMBERS_ID = "clusterTotalMembersText";
  public static final String CLUSTER_VIEW_LOCATORS_ID = "clusterLocatorsText";
  public static final String CLUSTER_VIEW_REGIONS_ID = "clusterTotalRegionsText";
  public static final String CLUSTER_CLIENTS_ID = "clusterClientsText";
  public static final String CLUSTER_FUNCTIONS_ID = "clusterFunctions";
  public static final String CLUSTER_UNIQUECQS_ID = "clusterUniqueCQs";
  public static final String CLUSTER_SUBSCRIPTION_ID = "clusterSubscriptionsText";
  public static final String CLUSTER_GCPAUSES_ID = "currentGCPauses";
  public static final String CLUSTER_WRITEPERSEC_ID = "writePerSec";
  public static final String CLUSTER_READPERSEC_ID = "readPerSec";
  public static final String CLUSTER_QUERIESPERSEC_ID = "queriesPerSec";
  public static final String MEMBER_VIEW_REGION_ID = "memberRegionsCount";
  public static final String MEMBER_VIEW_THREAD_ID = "threads";
  public static final String MEMBER_VIEW_SOCKETS_ID = "sockets";
  public static final String MEMBER_VIEW_LOADAVG_ID = "loadAverage";
  public static final String MEMBER_VIEW_JVMPAUSES_ID = "memberGcPausesAvg";
  public static final String MEMBER_VIEW_CPUUSAGE_ID = "memberCPUUsageValue";
  public static final String MEMBER_VIEW_READPERSEC_ID = "memberGetsPerSecValue";
  public static final String MEMBER_VIEW_WRITEPERSEC_ID = "memberPutsPerSecValue";
  public static final String MEMBER_VIEW_OFFHEAPFREESIZE_ID = "offHeapFreeSize";
  public static final String MEMBER_VIEW_OFFHEAPUSEDSIZE_ID = "offHeapUsedSize";

  public static final String REGION_NAME_LABEL = "regionName";
  public static final String REGION_PATH_LABEL = "regionPath";
  public static final String REGION_TYPE_LABEL = "regionType";
  public static final String DATA_VIEW_WRITEPERSEC = "regionWrites";
  public static final String DATA_VIEW_READPERSEC = "regionReads";
  public static final String DATA_VIEW_EMPTYNODES = "regionEmptyNodes";
  public static final String DATA_VIEW_ENTRYCOUNT = "regionEntryCount";
  public static final String REGION_PERSISTENCE_LABEL = "regionPersistence";
  public static final String DATA_VIEW_USEDMEMORY = "memoryUsed";

  public static final String DATA_BROWSER_LABEL = "Data Browser";
  public static final String DATA_BROWSER_REGIONName1 = "treeDemo_1_span";
  public static final String DATA_BROWSER_REGIONName2 = "treeDemo_2_span";
  public static final String DATA_BROWSER_REGIONName3 = "treeDemo_3_span";
  public static final String DATA_BROWSER_REGION1_CHECKBOX = "treeDemo_1_check";
  public static final String DATA_BROWSER_REGION2_CHECKBOX = "treeDemo_2_check";
  public static final String DATA_BROWSER_REGION3_CHECKBOX = "treeDemo_3_check";
  public static final String DATA_BROWSER_COLOCATED_REGION = "Colocated Regions";
  public static final String DATA_BROWSER_COLOCATED_REGION_NAME1 = "treeDemo_1_span";
  public static final String DATA_BROWSER_COLOCATED_REGION_NAME2 = "treeDemo_2_span";
  public static final String DATA_BROWSER_COLOCATED_REGION_NAME3 = "treeDemo_3_span";

  public static final String QUERY_STATISTICS_LABEL = "Query Statistics";
  public static final String CLUSTER_VIEW_LABEL = "Cluster View";
  public static final String CLUSTER_VIEW_GRID_ID = "default_treemap_button";
  public static final String SERVER_GROUP_GRID_ID = "servergroups_treemap_button";
  public static final String REDUNDANCY_GRID_ID = "redundancyzones_treemap_button";
  public static final String DATA_DROPDOWN_ID = "Data";
}
