/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.io.EOFException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.util.HashSet;
import java.util.List;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.CopyException;
import org.apache.geode.GemFireException;
import org.apache.geode.GemFireIOException;
import org.apache.geode.SerializationException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.CacheRuntimeException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.SynchronizationCommitConflictException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.ServerRefusedConnectionException;
import org.apache.geode.cache.client.SubscriptionNotEnabledException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.AuthenticateUserOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.Endpoint;
import org.apache.geode.cache.client.internal.EndpointManager;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.ExecuteFunctionOp;
import org.apache.geode.cache.client.internal.ExecuteRegionFunctionOp;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.cache.client.internal.PingOp;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.QueueManager;
import org.apache.geode.cache.client.internal.RegisterInterestTracker;
import org.apache.geode.cache.client.internal.TXFailoverOp;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.cache.client.internal.pooling.ConnectionDestroyedException;
import org.apache.geode.cache.client.internal.pooling.ConnectionManager;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.ServerLocationAndMemberId;
import org.apache.geode.internal.cache.PutAllPartialResultException;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.tier.BatchException;
import org.apache.geode.internal.cache.tier.sockets.MessageTooLargeException;
import org.apache.geode.internal.cache.wan.BatchException70;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.security.AuthenticationExpiredException;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpExecutorImpl
implements ExecutablePool {
    private static final Logger logger = LogService.getLogger();
    private static final boolean TRY_SERVERS_ONCE = Boolean.getBoolean("gemfire.PoolImpl.TRY_SERVERS_ONCE");
    static final int TX_RETRY_ATTEMPT = Integer.getInteger("gemfire.txRetryAttempt", 500);
    private final ConnectionManager connectionManager;
    private final int retryAttempts;
    private final long serverTimeout;
    private final long singleServerTimeout;
    private final EndpointManager endpointManager;
    private final RegisterInterestTracker riTracker;
    private final QueueManager queueManager;
    private final CancelCriterion cancelCriterion;
    private final PoolImpl pool;
    private final ThreadLocal<Boolean> serverAffinity = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private boolean serverAffinityFailover = false;
    private final ThreadLocal<ServerLocation> affinityServerLocation = new ThreadLocal();
    private final ThreadLocal<Integer> affinityRetryCount = ThreadLocal.withInitial(() -> 0);

    public OpExecutorImpl(@NotNull ConnectionManager connectionManager, @Nullable QueueManager queueManager, @NotNull EndpointManager endpointManager, @NotNull RegisterInterestTracker riTracker, int retryAttempts, long serverTimeout, long singleServerTimeout, @NotNull CancelCriterion cancelCriterion, @NotNull PoolImpl pool) {
        this.connectionManager = connectionManager;
        this.queueManager = queueManager;
        this.endpointManager = endpointManager;
        this.riTracker = riTracker;
        this.retryAttempts = retryAttempts;
        this.serverTimeout = serverTimeout;
        this.singleServerTimeout = singleServerTimeout;
        this.cancelCriterion = cancelCriterion;
        this.pool = pool;
    }

    @Override
    public Object execute(Op op) {
        return this.execute(op, this.retryAttempts);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Object execute(Op op, int retries) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object executeWithServerAffinity(ServerLocation loc, Op op) {
        int initialRetryCount = this.getAffinityRetryCount();
        try {
            Object object = this.executeOnServer(loc, op, true, false);
            return object;
        }
        catch (ServerConnectivityException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("caught exception while executing with affinity:{}", (Object)e.getMessage(), (Object)e);
            }
            if (!this.serverAffinityFailover || e instanceof ServerOperationException) {
                throw e;
            }
            int retryCount = this.getAffinityRetryCount();
            if (this.retryAttempts != -1 && retryCount >= this.retryAttempts || retryCount > TX_RETRY_ATTEMPT) {
                throw e;
            }
            this.setAffinityRetryCount(retryCount + 1);
            this.affinityServerLocation.set(null);
            if (logger.isDebugEnabled()) {
                logger.debug("reset server affinity: attempting txFailover");
            }
            AbstractOp absOp = (AbstractOp)op;
            absOp.getMessage().setIsRetry();
            int transactionId = absOp.getMessage().getTransactionId();
            TXFailoverOp.execute(this.pool, transactionId);
            if (op instanceof ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl) {
                op = new ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl((ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl)op, 1, new HashSet<String>());
                ((ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl)op).getMessage().setTransactionId(transactionId);
            } else if (op instanceof ExecuteFunctionOp.ExecuteFunctionOpImpl) {
                op = new ExecuteFunctionOp.ExecuteFunctionOpImpl((ExecuteFunctionOp.ExecuteFunctionOpImpl)op, 1);
                ((ExecuteFunctionOp.ExecuteFunctionOpImpl)op).getMessage().setTransactionId(transactionId);
            }
            Object object = this.pool.execute(op);
            return object;
        }
        finally {
            if (initialRetryCount == 0) {
                this.setAffinityRetryCount(0);
            }
        }
    }

    @Override
    public void setupServerAffinity(boolean allowFailover) {
        if (logger.isDebugEnabled()) {
            logger.debug("setting up server affinity");
        }
        this.serverAffinityFailover = allowFailover;
        this.serverAffinity.set(Boolean.TRUE);
    }

    @Override
    public void releaseServerAffinity() {
        if (logger.isDebugEnabled()) {
            logger.debug("reset server affinity");
        }
        this.serverAffinity.set(Boolean.FALSE);
        this.affinityServerLocation.set(null);
    }

    @Override
    public ServerLocation getServerAffinityLocation() {
        return this.affinityServerLocation.get();
    }

    int getAffinityRetryCount() {
        return this.affinityRetryCount.get();
    }

    void setAffinityRetryCount(int retryCount) {
        this.affinityRetryCount.set(retryCount);
    }

    @Override
    public void setServerAffinityLocation(ServerLocation serverLocation) {
        assert (this.affinityServerLocation.get() == null);
        this.affinityServerLocation.set(serverLocation);
    }

    public ServerLocation getNextOpServerLocation() {
        Connection conn = this.connectionManager.borrowConnection(this.serverTimeout);
        try {
            ServerLocation serverLocation = conn.getServer();
            return serverLocation;
        }
        finally {
            this.connectionManager.returnConnection(conn);
        }
    }

    @Override
    public Object executeOn(ServerLocation server, Op op) {
        return this.executeOn(server, op, true, false);
    }

    @Override
    public Object executeOn(ServerLocation server, Op op, boolean accessed, boolean onlyUseExistingCnx) {
        if (this.serverAffinity.get().booleanValue()) {
            ServerLocation affinityServer = this.affinityServerLocation.get();
            if (affinityServer != null) {
                server = affinityServer;
            } else {
                this.affinityServerLocation.set(server);
            }
            return this.executeWithServerAffinity(server, op);
        }
        return this.executeOnServer(server, op, accessed, onlyUseExistingCnx);
    }

    protected Object executeOnServer(ServerLocation server, Op op, boolean accessed, boolean onlyUseExistingConnection) {
        Object slAndMId;
        boolean returnConnection = true;
        Connection connection = null;
        if (op instanceof PingOp.PingOpImpl && this.queueManager != null) {
            QueueManager.QueueConnections queueConnections;
            slAndMId = new ServerLocationAndMemberId(server, ((PingOp.PingOpImpl)op).getServerID().getUniqueId());
            Endpoint endpoint = this.endpointManager.getEndpointMap().get(slAndMId);
            if (endpoint != null && (connection = (queueConnections = this.queueManager.getAllConnectionsNoWait()).getConnection(endpoint)) != null) {
                returnConnection = false;
            }
        }
        if (connection == null) {
            connection = this.connectionManager.borrowConnection(server, this.singleServerTimeout, onlyUseExistingConnection);
        }
        try {
            slAndMId = this.executeWithPossibleReAuthentication(connection, op);
            return slAndMId;
        }
        catch (Exception e) {
            this.handleException(e, connection, 0, true);
            throw new ServerConnectivityException("Received error connecting to server", e);
        }
        finally {
            if (this.serverAffinity.get().booleanValue() && this.affinityServerLocation.get() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("setting server affinity to {} server:{}", (Object)connection.getEndpoint().getMemberId(), (Object)connection.getServer());
                }
                this.affinityServerLocation.set(connection.getServer());
            }
            if (returnConnection) {
                this.connectionManager.returnConnection(connection, accessed);
            }
        }
    }

    @Override
    public Object executeOnPrimary(Op op) {
        if (this.queueManager == null) {
            throw new SubscriptionNotEnabledException();
        }
        HashSet<ServerLocation> attemptedPrimaries = new HashSet<ServerLocation>();
        while (true) {
            Connection primary = this.queueManager.getAllConnections().getPrimary();
            try {
                return this.executeWithPossibleReAuthentication(primary, op);
            }
            catch (Exception e) {
                boolean finalAttempt = !attemptedPrimaries.add(primary.getServer());
                this.handleException(e, primary, 0, finalAttempt);
                if (!finalAttempt) continue;
                throw new ServerConnectivityException("Tried the same primary server twice.", e);
            }
            break;
        }
    }

    @Override
    public void executeOnAllQueueServers(Op op) {
        if (this.queueManager == null) {
            throw new SubscriptionNotEnabledException();
        }
        RuntimeException lastException = null;
        QueueManager.QueueConnections connections = this.queueManager.getAllConnectionsNoWait();
        Connection primary = connections.getPrimary();
        if (primary != null) {
            try {
                this.executeWithPossibleReAuthentication(primary, op);
            }
            catch (Exception e) {
                try {
                    this.handleException(e, primary, 0, false);
                }
                catch (RuntimeException e2) {
                    lastException = e2;
                }
            }
        }
        List<Connection> backups = connections.getBackups();
        for (Connection connection : backups) {
            try {
                this.executeWithPossibleReAuthentication(connection, op);
            }
            catch (Exception e) {
                try {
                    this.handleException(e, connection, 0, false);
                }
                catch (RuntimeException e2) {
                    lastException = e2;
                }
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    @Override
    public Object executeOnQueuesAndReturnPrimaryResult(Op op) {
        if (this.queueManager == null) {
            throw new SubscriptionNotEnabledException();
        }
        QueueManager.QueueConnections connections = this.queueManager.getAllConnections();
        List<Connection> backups = connections.getBackups();
        if (logger.isTraceEnabled(LogMarker.BRIDGE_SERVER_VERBOSE)) {
            logger.trace(LogMarker.BRIDGE_SERVER_VERBOSE, "sending {} to backups: {}", (Object)op, backups);
        }
        for (int i = backups.size() - 1; i >= 0; --i) {
            Connection connection = backups.get(i);
            try {
                this.executeWithPossibleReAuthentication(connection, op);
                continue;
            }
            catch (Exception e) {
                this.handleException(e, connection, 0, false);
            }
        }
        Connection primary = connections.getPrimary();
        HashSet<ServerLocation> attemptedPrimaries = new HashSet<ServerLocation>();
        while (true) {
            try {
                if (logger.isTraceEnabled(LogMarker.BRIDGE_SERVER_VERBOSE)) {
                    logger.trace(LogMarker.BRIDGE_SERVER_VERBOSE, "sending {} to primary: {}", (Object)op, (Object)primary);
                }
                return this.executeWithPossibleReAuthentication(primary, op);
            }
            catch (Exception e) {
                if (logger.isTraceEnabled(LogMarker.BRIDGE_SERVER_VERBOSE)) {
                    logger.trace(LogMarker.BRIDGE_SERVER_VERBOSE, "caught exception sending to primary {}", (Object)e.getMessage(), (Object)e);
                }
                boolean finalAttempt = !attemptedPrimaries.add(primary.getServer());
                this.handleException(e, primary, 0, finalAttempt);
                primary = this.queueManager.getAllConnections().getPrimary();
                if (!finalAttempt) continue;
                throw new ServerConnectivityException("Tried the same primary server twice.", e);
            }
            break;
        }
    }

    @Override
    public Object executeOn(Connection connection, Op op, boolean timeoutFatal) {
        try {
            return this.executeWithPossibleReAuthentication(connection, op);
        }
        catch (Exception e) {
            this.handleException(op, e, connection, 0, true, timeoutFatal);
            throw new ServerConnectivityException("Received error connecting to server", e);
        }
    }

    @Override
    public Object executeOn(Connection connection, Op op) {
        return this.executeOn(connection, op, false);
    }

    @Override
    public RegisterInterestTracker getRITracker() {
        return this.riTracker;
    }

    protected void handleException(Throwable e, Connection conn, int retryCount, boolean finalAttempt) {
        OpExecutorImpl.handleException(e, conn, retryCount, finalAttempt, false, this.cancelCriterion, this.endpointManager);
    }

    private void handleException(Op op, Throwable e, Connection conn, int retryCount, boolean finalAttempt, boolean timeoutFatal) throws CacheRuntimeException {
        if (op instanceof AuthenticateUserOp.AuthenticateUserOpImpl) {
            if (e instanceof GemFireSecurityException) {
                throw (GemFireSecurityException)e;
            }
            if (e instanceof ServerRefusedConnectionException) {
                throw (ServerRefusedConnectionException)e;
            }
        }
        OpExecutorImpl.handleException(e, conn, retryCount, finalAttempt, timeoutFatal, this.cancelCriterion, this.endpointManager);
    }

    static void handleException(@NotNull Throwable throwable, @NotNull Connection connection, int retryCount, boolean finalAttempt, boolean timeoutFatal, @NotNull CancelCriterion cancelCriterion, @NotNull EndpointManager endpointManager) throws CacheRuntimeException {
        String title;
        cancelCriterion.checkCancelInProgress(throwable);
        if (logger.isDebugEnabled() && !(throwable instanceof EOFException)) {
            if (throwable instanceof SocketTimeoutException) {
                logger.debug("OpExecutor.handleException on Connection to {} read timed out", (Object)connection.getServer());
            } else {
                logger.debug("OpExecutor.handleException on Connection to {}", (Object)connection.getServer(), (Object)throwable);
            }
        }
        GemFireException exceptionToThrow = null;
        boolean invalidateServer = true;
        boolean warn = true;
        boolean forceThrow = false;
        Throwable cause = throwable;
        if (throwable instanceof MessageTooLargeException) {
            title = null;
            exceptionToThrow = new GemFireIOException("message is too large to transmit", throwable);
        } else if (throwable instanceof NotSerializableException) {
            title = null;
            exceptionToThrow = new SerializationException("Pool message failure", throwable);
        } else if (throwable instanceof BatchException || throwable instanceof BatchException70) {
            title = null;
            exceptionToThrow = new ServerOperationException(throwable);
        } else if (throwable instanceof RegionDestroyedException) {
            invalidateServer = false;
            title = null;
            exceptionToThrow = (RegionDestroyedException)throwable;
        } else if (throwable instanceof GemFireSecurityException) {
            title = null;
            exceptionToThrow = new ServerOperationException(throwable);
        } else if (throwable instanceof SerializationException) {
            title = null;
            exceptionToThrow = new ServerOperationException(throwable);
        } else if (throwable instanceof CopyException) {
            title = null;
            exceptionToThrow = new ServerOperationException(throwable);
        } else if (throwable instanceof ClassNotFoundException) {
            title = null;
            exceptionToThrow = new ServerOperationException(throwable);
        } else if (throwable instanceof TransactionException) {
            title = null;
            exceptionToThrow = (TransactionException)throwable;
            invalidateServer = false;
        } else if (throwable instanceof SynchronizationCommitConflictException) {
            title = null;
            exceptionToThrow = (SynchronizationCommitConflictException)throwable;
            invalidateServer = false;
        } else if (throwable instanceof SocketException) {
            title = "Socket closed".equals(throwable.getMessage()) || "Connection reset".equals(throwable.getMessage()) || "Connection refused: connect".equals(throwable.getMessage()) || "Connection refused".equals(throwable.getMessage()) ? throwable.getMessage() : "SocketException";
        } else if (throwable instanceof SocketTimeoutException) {
            invalidateServer = timeoutFatal;
            title = "socket timed out on client";
            cause = null;
        } else if (throwable instanceof ConnectionDestroyedException) {
            invalidateServer = false;
            title = "connection was asynchronously destroyed";
            cause = null;
        } else if (throwable instanceof EOFException) {
            title = "closed socket on server";
        } else if (throwable instanceof IOException) {
            title = "IOException";
        } else if (throwable instanceof BufferUnderflowException) {
            title = "buffer underflow reading from server";
        } else if (throwable instanceof CancelException) {
            title = "Cancelled";
            warn = false;
        } else if (throwable instanceof InternalFunctionInvocationTargetException) {
            title = null;
            exceptionToThrow = (InternalFunctionInvocationTargetException)throwable;
        } else if (throwable instanceof FunctionInvocationTargetException) {
            title = null;
            exceptionToThrow = (GemFireException)throwable;
        } else if (throwable instanceof PutAllPartialResultException) {
            title = null;
            exceptionToThrow = (PutAllPartialResultException)throwable;
            invalidateServer = false;
        } else {
            Throwable t = throwable.getCause();
            if (t instanceof IOException || t instanceof SerializationException || t instanceof CopyException || t instanceof GemFireSecurityException || t instanceof ServerOperationException || t instanceof TransactionException || t instanceof CancelException) {
                OpExecutorImpl.handleException(t, connection, retryCount, finalAttempt, timeoutFatal, cancelCriterion, endpointManager);
                return;
            }
            if (throwable instanceof ServerOperationException) {
                title = null;
                exceptionToThrow = (ServerOperationException)throwable;
                invalidateServer = false;
            } else if (throwable instanceof FunctionException) {
                if (t instanceof InternalFunctionInvocationTargetException) {
                    OpExecutorImpl.handleException(t, connection, retryCount, finalAttempt, timeoutFatal, cancelCriterion, endpointManager);
                    return;
                }
                title = null;
                exceptionToThrow = (FunctionException)throwable;
            } else if (throwable instanceof ServerConnectivityException && throwable.getMessage().equals("Connection error while authenticating user")) {
                title = null;
                if (logger.isDebugEnabled()) {
                    logger.debug(throwable.getMessage(), throwable);
                }
            } else {
                title = throwable.toString();
                forceThrow = true;
            }
        }
        if (title != null) {
            boolean msgNeeded;
            connection.destroy();
            if (invalidateServer) {
                endpointManager.serverCrashed(connection.getEndpoint());
            }
            boolean logEnabled = warn ? logger.isWarnEnabled() : logger.isDebugEnabled();
            boolean bl = msgNeeded = logEnabled || finalAttempt;
            if (msgNeeded) {
                StringBuilder sb = OpExecutorImpl.getExceptionMessage(title, retryCount, finalAttempt, connection);
                String msg = sb.toString();
                if (logEnabled) {
                    if (warn) {
                        logger.warn(msg);
                    } else {
                        logger.debug(msg, throwable);
                    }
                }
                if (forceThrow || finalAttempt) {
                    exceptionToThrow = new ServerConnectivityException(msg, cause);
                }
            }
        }
        if (exceptionToThrow != null) {
            throw exceptionToThrow;
        }
    }

    private static StringBuilder getExceptionMessage(String exceptionName, int retryCount, boolean finalAttempt, Connection connection) {
        StringBuilder message = new StringBuilder(200);
        message.append("Pool unexpected ").append(exceptionName);
        if (connection != null) {
            message.append(" connection=").append(connection);
        }
        if (retryCount > 0) {
            message.append(" attempt=").append(retryCount + 1);
        }
        message.append(')');
        if (finalAttempt) {
            message.append(". Server unreachable: could not connect after ").append(retryCount + 1).append(" attempts");
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void authenticateIfMultiUser(Connection connection, Op op) {
        if (!connection.getServer().getRequiresCredentials()) {
            return;
        }
        if (!((AbstractOp)op).needsUserId()) {
            return;
        }
        if (!this.pool.getMultiuserAuthentication()) {
            return;
        }
        UserAttributes ua = this.getUserAttributesFromThreadLocal();
        if (ua == null) {
            return;
        }
        UserAttributes userAttributes = ua;
        synchronized (userAttributes) {
            if (ua.getServerToId().containsKey(connection.getServer())) {
                return;
            }
            this.authenticateMultiuser(this.pool, connection, ua);
        }
    }

    @VisibleForTesting
    UserAttributes getUserAttributesFromThreadLocal() {
        return UserAttributes.userAttributes.get();
    }

    @VisibleForTesting
    void authenticateMultiuser(PoolImpl pool, Connection conn, UserAttributes ua) {
        try {
            Long userId = AuthenticateUserOp.executeOn(conn.getServer(), pool, ua.getCredentials());
            if (userId != null) {
                ua.setServerToId(conn.getServer(), userId);
                if (logger.isDebugEnabled()) {
                    logger.debug("OpExecutorImpl.execute() - multiuser mode - authenticated this user on {}", (Object)conn);
                }
            }
        }
        catch (ServerConnectivityException sce) {
            Throwable cause = sce.getCause();
            if (cause instanceof IOException || cause instanceof BufferUnderflowException || cause instanceof CancelException || sce.getMessage() != null && (sce.getMessage().contains("Could not create a new connection to server") || sce.getMessage().contains("socket timed out on client") || sce.getMessage().contains("connection was asynchronously destroyed"))) {
                throw new ServerConnectivityException("Connection error while authenticating user");
            }
            throw sce;
        }
    }

    private Object executeWithPossibleReAuthentication(Connection conn, Op op) throws Exception {
        try {
            return conn.execute(op);
        }
        catch (ServerConnectivityException sce) {
            Throwable cause = sce.getCause();
            if (cause instanceof AuthenticationRequiredException && "User authorization attributes not found.".equals(cause.getMessage()) || sce.getMessage().contains("Connection error while authenticating user") || cause instanceof AuthenticationExpiredException) {
                if (this.pool.getMultiuserAuthentication()) {
                    UserAttributes ua = this.getUserAttributesFromThreadLocal();
                    if (ua != null) {
                        this.authenticateMultiuser(this.pool, conn, ua);
                    }
                } else {
                    Connection wrappedConnection = conn.getWrappedConnection();
                    conn.getServer().setUserId(AuthenticateUserOp.executeOn(wrappedConnection, (ExecutablePool)this));
                }
                return conn.execute(op);
            }
            throw sce;
        }
    }
}

