/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.statalerts;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.internal.admin.StatAlert;
import org.apache.geode.internal.admin.StatAlertDefinition;
import org.apache.geode.internal.admin.statalerts.MultiAttrDefinitionImpl;
import org.apache.geode.internal.admin.statalerts.StatisticInfo;

public class SingleAttrDefinitionImpl
implements StatAlertDefinition {
    private static final long serialVersionUID = 3292417185742697896L;
    protected String name;
    protected int _id;
    protected StatisticInfo statisticInfo;

    public SingleAttrDefinitionImpl() {
    }

    public SingleAttrDefinitionImpl(String name, StatisticInfo statisticInfo) {
        this.statisticInfo = statisticInfo;
        this.name = name;
        this._id = this.getName().toUpperCase().hashCode();
    }

    @Override
    public int getId() {
        return this._id;
    }

    public int hashCode() {
        return this.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiAttrDefinitionImpl)) {
            return false;
        }
        MultiAttrDefinitionImpl that = (MultiAttrDefinitionImpl)o;
        return this._id == that._id;
    }

    @Override
    public boolean verify(StatisticsFactory factory) {
        boolean result = false;
        if (this.name == null || this.name.length() == 0) {
            return false;
        }
        if (this.statisticInfo != null) {
            StatisticDescriptor[] temp1;
            Statistics[] temp = factory.findStatisticsByTextId(this.statisticInfo.getStatisticsTextId());
            if (temp == null || temp.length == 0) {
                return false;
            }
            for (StatisticDescriptor statisticDescriptor : temp1 = temp[0].getType().getStatistics()) {
                if (!this.statisticInfo.getStatisticName().equals(statisticDescriptor.getName())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public String getStringRepresentation() {
        return "StatAlertDefinition [\n" + this + "]";
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Name:" + this.getName() + "\n");
        buffer.append("Attribute:\n");
        if (this.statisticInfo != null) {
            buffer.append(this.statisticInfo + "\n");
        }
        return buffer.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public StatisticInfo[] getStatisticInfo() {
        return new StatisticInfo[]{this.statisticInfo};
    }

    @Override
    public void setStatisticInfo(StatisticInfo[] info) {
        if (info == null || info.length != 1) {
            throw new IllegalArgumentException("setStatisticInfo method requires 1 length array of StatisticInfo objects.");
        }
        this.statisticInfo = info[0];
    }

    @Override
    public Number[] getValue() {
        Number[] vals = new Number[]{this.statisticInfo.getStatistics().get(this.statisticInfo.getStatisticDescriptor())};
        return vals;
    }

    @Override
    public Number[] getValue(Number[] vals) {
        return vals;
    }

    @Override
    public boolean evaluate(Number[] params) {
        return this.evaluate() && params != null && params.length == 1;
    }

    @Override
    public boolean evaluate() {
        return this.statisticInfo != null;
    }

    @Override
    public StatAlert evaluateAndAlert(Number[] params) {
        return this.evaluate(params) ? this.getAlert(params[0]) : null;
    }

    @Override
    public StatAlert evaluateAndAlert() {
        return this.evaluate() ? this.getAlert(this.getValue()[0]) : null;
    }

    protected StatAlert getAlert(Number val) {
        Number[] vals = new Number[]{val};
        return new StatAlert(this.getId(), vals);
    }

    @Override
    public boolean hasDecorator(String decoratorID) {
        return false;
    }

    @Override
    public StatAlertDefinition getDecorator(String decoratorID) {
        return null;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.name, out);
        DataSerializer.writePrimitiveInt(this._id, out);
        DataSerializer.writeObject(this.statisticInfo, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.name = DataSerializer.readString(in);
        this._id = DataSerializer.readPrimitiveInt(in);
        this.statisticInfo = (StatisticInfo)DataSerializer.readObject(in);
    }
}

