/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.geode.DataSerializer;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.CacheCallback;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.CacheStatistics;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DiskWriteAttributes;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.EvictionAttributesMutator;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.MembershipAttributes;
import org.apache.geode.cache.MirrorType;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionMembershipListener;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.StatisticsDisabledException;
import org.apache.geode.cache.SubscriptionAttributes;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.cache.snapshot.RegionSnapshotService;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.compression.Compressor;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EntryExpiryTask;
import org.apache.geode.internal.cache.EvictableRegion;
import org.apache.geode.internal.cache.EvictionAttributesImpl;
import org.apache.geode.internal.cache.EvictionAttributesMutatorImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionAttributesImpl;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEventImpl;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.WrappedRegionMembershipListener;
import org.apache.geode.internal.cache.extension.Extensible;
import org.apache.geode.internal.cache.extension.ExtensionPoint;
import org.apache.geode.internal.cache.extension.SimpleExtensionPoint;
import org.apache.geode.internal.cache.snapshot.RegionSnapshotServiceImpl;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.internal.statistics.StatisticsClockFactory;
import org.apache.geode.internal.util.ArrayUtils;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.logging.internal.log4j.api.LogWithToString;
import org.apache.logging.log4j.Logger;

public abstract class AbstractRegion
implements InternalRegion,
AttributesMutator,
CacheStatistics,
DataSerializableFixedID,
Extensible<Region<?, ?>>,
EvictableRegion,
LogWithToString {
    private static final Logger logger = LogService.getLogger();
    private final ReentrantReadWriteLock readWriteLockForCacheLoader = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock readWriteLockForCacheWriter = new ReentrantReadWriteLock();
    protected final ConcurrentHashMap<RegionEntry, EntryExpiryTask> entryExpiryTasks = new ConcurrentHashMap();
    private final int serialNumber;
    private final Object clSync = new Object();
    private final Object imSync = new Object();
    private volatile CacheListener[] cacheListeners;
    private volatile CacheLoader cacheLoader;
    private volatile CacheWriter cacheWriter;
    protected int entryIdleTimeout;
    private ExpirationAction entryIdleTimeoutExpirationAction;
    protected CustomExpiry customEntryIdleTimeout;
    protected int entryTimeToLive;
    ExpirationAction entryTimeToLiveExpirationAction;
    protected CustomExpiry customEntryTimeToLive;
    protected int initialCapacity;
    protected Class keyConstraint;
    protected Class valueConstraint;
    protected float loadFactor;
    private DataPolicy dataPolicy;
    protected int regionIdleTimeout;
    private ExpirationAction regionIdleTimeoutExpirationAction;
    protected int regionTimeToLive;
    private ExpirationAction regionTimeToLiveExpirationAction;
    @Immutable
    public static final Scope DEFAULT_SCOPE = Scope.DISTRIBUTED_NO_ACK;
    protected Scope scope = DEFAULT_SCOPE;
    protected boolean statisticsEnabled;
    protected boolean isLockGrantor;
    private boolean mcastEnabled;
    protected int concurrencyLevel;
    private volatile boolean concurrencyChecksEnabled;
    protected boolean earlyAck;
    private final boolean isPdxTypesRegion;
    protected Set<String> gatewaySenderIds;
    protected Set<String> asyncEventQueueIds;
    private Set<String> visibleAsyncEventQueueIds;
    private Set<String> allGatewaySenderIds;
    protected boolean enableSubscriptionConflation;
    protected boolean publisher;
    protected boolean enableAsyncConflation;
    protected boolean offHeap;
    private boolean cloningEnable = false;
    private DiskWriteAttributes diskWriteAttributes;
    protected File[] diskDirs;
    protected int[] diskSizes;
    protected String diskStoreName;
    protected boolean isDiskSynchronous;
    private boolean indexMaintenanceSynchronous = false;
    protected volatile IndexManager indexManager = null;
    private static final ThreadLocal<Boolean> isIndexCreator = new ThreadLocal();
    protected PartitionAttributes partitionAttributes;
    private final EvictionAttributesImpl evictionAttributes;
    protected MembershipAttributes membershipAttributes;
    protected SubscriptionAttributes subscriptionAttributes;
    protected boolean ignoreJTA;
    private final AtomicLong lastAccessedTime;
    private final AtomicLong lastModifiedTime;
    private static final boolean trackHits = !Boolean.getBoolean("gemfire.ignoreHits");
    private static final boolean trackMisses = !Boolean.getBoolean("gemfire.ignoreMisses");
    private final AtomicLong hitCount = new AtomicLong();
    private final AtomicLong missCount = new AtomicLong();
    protected String poolName;
    protected Compressor compressor;
    private final ExtensionPoint<Region<?, ?>> extensionPoint = new SimpleExtensionPoint<AbstractRegion>(this, this);
    protected final InternalCache cache;
    private final PoolFinder poolFinder;
    private final StatisticsClock statisticsClock;
    private volatile ExpirationAttributes regionTimeToLiveAtts;
    private volatile ExpirationAttributes regionIdleTimeoutAttributes;
    private volatile ExpirationAttributes entryTimeToLiveAtts;
    private volatile ExpirationAttributes entryIdleTimeoutAttributes;
    @Immutable
    private static final CacheListener[] EMPTY_LISTENERS = new CacheListener[0];
    private boolean entryExpiryPossible = false;

    protected AbstractRegion(InternalCache cache, RegionAttributes<?, ?> attrs, String regionName, InternalRegionArguments internalRegionArgs, PoolFinder poolFinder, StatisticsClock statisticsClock) {
        this.poolFinder = poolFinder;
        this.statisticsClock = statisticsClock;
        this.cache = cache;
        this.serialNumber = DistributionAdvisor.createSerialNumber();
        this.isPdxTypesRegion = "PdxTypes".equals(regionName);
        this.lastAccessedTime = new AtomicLong(this.cacheTimeMillis());
        this.lastModifiedTime = new AtomicLong(this.lastAccessedTime.get());
        this.dataPolicy = attrs.getDataPolicy();
        this.scope = attrs.getScope();
        this.offHeap = attrs.getOffHeap();
        PartitionAttributes partitionAttributes1 = attrs.getPartitionAttributes();
        if (this.offHeap && partitionAttributes1 != null) {
            PartitionAttributesImpl impl = (PartitionAttributesImpl)partitionAttributes1;
            impl.setOffHeap(true);
        }
        this.evictionAttributes = new EvictionAttributesImpl(attrs.getEvictionAttributes());
        if (attrs.getPartitionAttributes() != null && this.evictionAttributes.getAlgorithm().isLRUMemory() && attrs.getPartitionAttributes().getLocalMaxMemory() != 0 && this.evictionAttributes.getMaximum() != attrs.getPartitionAttributes().getLocalMaxMemory()) {
            logger.warn("For region {} with data policy PARTITION, memory LRU eviction attribute maximum has been reset from {}MB to local-max-memory {}MB", new Object[]{regionName, this.evictionAttributes.getMaximum(), attrs.getPartitionAttributes().getLocalMaxMemory()});
            this.evictionAttributes.setMaximum(attrs.getPartitionAttributes().getLocalMaxMemory());
        }
        this.storeCacheListenersField(attrs.getCacheListeners());
        this.assignCacheLoader(attrs.getCacheLoader());
        this.assignCacheWriter(attrs.getCacheWriter());
        this.regionTimeToLive = attrs.getRegionTimeToLive().getTimeout();
        this.regionTimeToLiveExpirationAction = attrs.getRegionTimeToLive().getAction();
        this.setRegionTimeToLiveAtts();
        this.regionIdleTimeout = attrs.getRegionIdleTimeout().getTimeout();
        this.regionIdleTimeoutExpirationAction = attrs.getRegionIdleTimeout().getAction();
        this.setRegionIdleTimeoutAttributes();
        this.entryTimeToLive = attrs.getEntryTimeToLive().getTimeout();
        this.entryTimeToLiveExpirationAction = attrs.getEntryTimeToLive().getAction();
        this.setEntryTimeToLiveAttributes();
        this.customEntryTimeToLive = attrs.getCustomEntryTimeToLive();
        this.entryIdleTimeout = attrs.getEntryIdleTimeout().getTimeout();
        this.entryIdleTimeoutExpirationAction = attrs.getEntryIdleTimeout().getAction();
        this.setEntryIdleTimeoutAttributes();
        this.customEntryIdleTimeout = attrs.getCustomEntryIdleTimeout();
        this.updateEntryExpiryPossible();
        this.statisticsEnabled = attrs.getStatisticsEnabled();
        this.ignoreJTA = attrs.getIgnoreJTA();
        this.isLockGrantor = attrs.isLockGrantor();
        this.keyConstraint = attrs.getKeyConstraint();
        this.valueConstraint = attrs.getValueConstraint();
        this.initialCapacity = attrs.getInitialCapacity();
        this.loadFactor = attrs.getLoadFactor();
        this.concurrencyLevel = attrs.getConcurrencyLevel();
        this.setConcurrencyChecksEnabled(attrs.getConcurrencyChecksEnabled() && this.supportsConcurrencyChecks());
        this.earlyAck = attrs.getEarlyAck();
        this.gatewaySenderIds = attrs.getGatewaySenderIds();
        this.asyncEventQueueIds = attrs.getAsyncEventQueueIds();
        this.initializeVisibleAsyncEventQueueIds(internalRegionArgs);
        this.setAllGatewaySenderIds();
        this.enableSubscriptionConflation = attrs.getEnableSubscriptionConflation();
        this.publisher = attrs.getPublisher();
        this.enableAsyncConflation = attrs.getEnableAsyncConflation();
        this.indexMaintenanceSynchronous = attrs.getIndexMaintenanceSynchronous();
        this.mcastEnabled = attrs.getMulticastEnabled();
        this.partitionAttributes = attrs.getPartitionAttributes();
        this.membershipAttributes = attrs.getMembershipAttributes();
        this.subscriptionAttributes = attrs.getSubscriptionAttributes();
        this.cloningEnable = attrs.getCloningEnabled();
        this.poolName = attrs.getPoolName();
        if (this.poolName != null) {
            PoolImpl cp = this.getPool();
            if (cp == null) {
                throw new IllegalStateException(String.format("The connection pool %s has not been created", this.poolName));
            }
            cp.attach();
            if (cp.getMultiuserAuthentication() && !this.getDataPolicy().isEmpty()) {
                throw new IllegalStateException("Region must have empty data-policy when multiuser-authentication is true.");
            }
        }
        this.diskStoreName = attrs.getDiskStoreName();
        this.isDiskSynchronous = attrs.isDiskSynchronous();
        if (this.diskStoreName == null) {
            this.diskWriteAttributes = attrs.getDiskWriteAttributes();
            this.isDiskSynchronous = this.diskWriteAttributes.isSynchronous();
            this.diskDirs = attrs.getDiskDirs();
            this.diskSizes = attrs.getDiskDirSizes();
        }
        this.compressor = attrs.getCompressor();
        if (!attrs.getConcurrencyChecksEnabled() && attrs.getDataPolicy().withPersistence() && this.supportsConcurrencyChecks()) {
            throw new IllegalStateException("Concurrency checks cannot be disabled for regions that use persistence");
        }
    }

    @VisibleForTesting
    AbstractRegion() {
        this.statisticsClock = StatisticsClockFactory.disabledClock();
        this.cache = null;
        this.serialNumber = 0;
        this.isPdxTypesRegion = false;
        this.lastAccessedTime = new AtomicLong(0L);
        this.lastModifiedTime = new AtomicLong(0L);
        this.evictionAttributes = new EvictionAttributesImpl();
        this.poolFinder = a -> null;
    }

    @Deprecated
    public void setIgnoreJTA(boolean ignore) {
        this.ignoreJTA = ignore;
    }

    public void create(Object key, Object value) throws TimeoutException, EntryExistsException, CacheWriterException {
        this.create(key, value, null);
    }

    public Object destroy(Object key) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        return this.destroy(key, null);
    }

    @Override
    public Object get(Object key) throws CacheLoaderException, TimeoutException {
        return this.get(key, null, true, null);
    }

    @Override
    public Object put(Object key, Object value) throws TimeoutException, CacheWriterException {
        return this.put(key, value, null);
    }

    public Object get(Object key, Object aCallbackArgument) throws CacheLoaderException, TimeoutException {
        return this.get(key, aCallbackArgument, true, null);
    }

    @Override
    public void localDestroyRegion() {
        this.localDestroyRegion(null);
    }

    abstract Object get(Object var1, Object var2, boolean var3, EntryEventImpl var4) throws TimeoutException, CacheLoaderException;

    @Override
    public void localDestroy(Object key) throws EntryNotFoundException {
        this.localDestroy(key, null);
    }

    @Override
    public void destroyRegion() throws CacheWriterException, TimeoutException {
        this.destroyRegion(null);
    }

    @Override
    public void invalidate(Object key) throws TimeoutException, EntryNotFoundException {
        this.invalidate(key, null);
    }

    @Override
    public void localInvalidate(Object key) throws EntryNotFoundException {
        this.localInvalidate(key, null);
    }

    @Override
    public void localInvalidateRegion() {
        this.localInvalidateRegion(null);
    }

    @Override
    public void invalidateRegion() throws TimeoutException {
        this.invalidateRegion(null);
    }

    abstract void basicClear(RegionEventImpl var1);

    @Override
    public void clear() {
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        RegionEventImpl regionEvent = new RegionEventImpl((Region)this, Operation.REGION_CLEAR, null, false, (DistributedMember)this.getMyId(), this.generateEventID());
        this.basicClear(regionEvent);
    }

    abstract void basicLocalClear(RegionEventImpl var1);

    @Override
    public void localClear() {
        this.checkReadiness();
        this.checkForNoAccess();
        RegionEventImpl event = new RegionEventImpl((Region)this, Operation.REGION_LOCAL_CLEAR, null, false, (DistributedMember)this.getMyId(), this.generateEventID());
        this.basicLocalClear(event);
    }

    public Map getAll(Collection keys) {
        return this.getAll(keys, (Object)null);
    }

    public Map getAll(Collection keys, Object aCallbackArgument) {
        if (keys == null) {
            throw new NullPointerException("The collection of keys for getAll cannot be null");
        }
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        return keys.isEmpty() ? new HashMap() : this.basicGetAll(keys, aCallbackArgument);
    }

    abstract Map basicGetAll(Collection var1, Object var2);

    protected StringBuilder getStringBuilder() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getName());
        buf.append("[path='").append(this.getFullPath()).append("';scope=").append(this.getScope()).append("';dataPolicy=").append(this.getDataPolicy());
        if (this.getConcurrencyChecksEnabled()) {
            buf.append("; concurrencyChecksEnabled");
        }
        return buf;
    }

    public String toString() {
        return this.getStringBuilder().append(']').toString();
    }

    public CacheLoader getCacheLoader() {
        this.readWriteLockForCacheLoader.readLock().lock();
        try {
            CacheLoader cacheLoader = this.cacheLoader;
            return cacheLoader;
        }
        finally {
            this.readWriteLockForCacheLoader.readLock().unlock();
        }
    }

    public CacheWriter getCacheWriter() {
        this.readWriteLockForCacheWriter.readLock().lock();
        try {
            CacheWriter cacheWriter = this.cacheWriter;
            return cacheWriter;
        }
        finally {
            this.readWriteLockForCacheWriter.readLock().unlock();
        }
    }

    CacheLoader basicGetLoader() {
        return this.cacheLoader;
    }

    @Override
    public CacheWriter basicGetWriter() {
        return this.cacheWriter;
    }

    public Class getKeyConstraint() {
        return this.keyConstraint;
    }

    public Class getValueConstraint() {
        return this.valueConstraint;
    }

    private void setRegionTimeToLiveAtts() {
        this.regionTimeToLiveAtts = new ExpirationAttributes(this.regionTimeToLive, this.regionTimeToLiveExpirationAction);
    }

    @Override
    public ExpirationAttributes getRegionTimeToLive() {
        return this.regionTimeToLiveAtts;
    }

    private void setRegionIdleTimeoutAttributes() {
        this.regionIdleTimeoutAttributes = new ExpirationAttributes(this.regionIdleTimeout, this.regionIdleTimeoutExpirationAction);
    }

    @Override
    public ExpirationAttributes getRegionIdleTimeout() {
        return this.regionIdleTimeoutAttributes;
    }

    void setEntryTimeToLiveAttributes() {
        this.entryTimeToLiveAtts = new ExpirationAttributes(this.entryTimeToLive, this.entryTimeToLiveExpirationAction);
    }

    @Override
    public ExpirationAttributes getEntryTimeToLive() {
        return this.entryTimeToLiveAtts;
    }

    public CustomExpiry getCustomEntryTimeToLive() {
        return this.customEntryTimeToLive;
    }

    private void setEntryIdleTimeoutAttributes() {
        this.entryIdleTimeoutAttributes = new ExpirationAttributes(this.entryIdleTimeout, this.entryIdleTimeoutExpirationAction);
    }

    @Override
    public ExpirationAttributes getEntryIdleTimeout() {
        return this.entryIdleTimeoutAttributes;
    }

    public CustomExpiry getCustomEntryIdleTimeout() {
        return this.customEntryIdleTimeout;
    }

    @Override
    public MirrorType getMirrorType() {
        if (this.getDataPolicy().isNormal() || this.getDataPolicy().isPreloaded() || this.getDataPolicy().isEmpty() || this.getDataPolicy().withPartitioning()) {
            return MirrorType.NONE;
        }
        if (this.getDataPolicy().withReplication()) {
            return MirrorType.KEYS_VALUES;
        }
        throw new IllegalStateException(String.format("No mirror type corresponds to data policy %s", this.getDataPolicy()));
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    @Override
    public DataPolicy getDataPolicy() {
        return this.dataPolicy;
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    public CacheListener getCacheListener() {
        CacheListener[] listeners = this.fetchCacheListenersField();
        if (listeners == null || listeners.length == 0) {
            return null;
        }
        if (listeners.length == 1) {
            return listeners[0];
        }
        throw new IllegalStateException("More than one cache listener exists.");
    }

    public boolean isPdxTypesRegion() {
        return this.isPdxTypesRegion;
    }

    @Override
    public Set<String> getGatewaySenderIds() {
        return this.gatewaySenderIds;
    }

    @Override
    public Set<String> getAsyncEventQueueIds() {
        return this.asyncEventQueueIds;
    }

    @Override
    public Set<String> getVisibleAsyncEventQueueIds() {
        return this.visibleAsyncEventQueueIds;
    }

    @Override
    public Set<String> getAllGatewaySenderIds() {
        return this.allGatewaySenderIds;
    }

    List<Integer> getRemoteDsIds(Set<String> allGatewaySenderIds) throws IllegalStateException {
        int sz = allGatewaySenderIds.size();
        Set<GatewaySender> allGatewaySenders = this.cache.getAllGatewaySenders();
        if ((sz > 0 || this.isPdxTypesRegion) && !allGatewaySenders.isEmpty()) {
            ArrayList<Integer> allRemoteDSIds = new ArrayList<Integer>(sz);
            for (GatewaySender sender : allGatewaySenders) {
                if (!this.isPdxTypesRegion) {
                    if (!AbstractRegion.hasRunningGatewaySender(allGatewaySenders, sender)) continue;
                    allRemoteDSIds.add(sender.getRemoteDSId());
                    continue;
                }
                allRemoteDSIds.add(sender.getRemoteDSId());
            }
            return allRemoteDSIds;
        }
        return null;
    }

    public CacheListener[] getCacheListeners() {
        CacheListener[] listeners = this.fetchCacheListenersField();
        if (listeners == null || listeners.length == 0) {
            return EMPTY_LISTENERS;
        }
        CacheListener[] result = new CacheListener[listeners.length];
        System.arraycopy(listeners, 0, result, 0, listeners.length);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeCacheListenersField(CacheListener[] value) {
        Object object = this.clSync;
        synchronized (object) {
            if (value != null && value.length != 0) {
                CacheListener[] cacheListeners = new CacheListener[value.length];
                System.arraycopy(value, 0, cacheListeners, 0, cacheListeners.length);
                value = cacheListeners;
            } else {
                value = EMPTY_LISTENERS;
            }
            this.cacheListeners = value;
        }
    }

    CacheListener[] fetchCacheListenersField() {
        return this.cacheListeners;
    }

    @Override
    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    @Override
    public float getLoadFactor() {
        return this.loadFactor;
    }

    abstract boolean isCurrentlyLockGrantor();

    @Override
    public boolean isLockGrantor() {
        return this.isLockGrantor;
    }

    @Override
    public boolean getMulticastEnabled() {
        return this.mcastEnabled;
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public boolean getIgnoreJTA() {
        return this.ignoreJTA;
    }

    @Override
    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    @Override
    public boolean getConcurrencyChecksEnabled() {
        return this.concurrencyChecksEnabled;
    }

    public void setConcurrencyChecksEnabled(boolean concurrencyChecksEnabled) {
        this.concurrencyChecksEnabled = concurrencyChecksEnabled;
    }

    @Override
    public boolean getPersistBackup() {
        return this.getDataPolicy().withPersistence();
    }

    @Override
    public boolean getEarlyAck() {
        return this.earlyAck;
    }

    @Override
    @Deprecated
    public boolean getPublisher() {
        return this.publisher;
    }

    @Override
    public boolean getEnableConflation() {
        return this.getEnableSubscriptionConflation();
    }

    @Override
    public boolean getEnableBridgeConflation() {
        return this.getEnableSubscriptionConflation();
    }

    @Override
    public boolean getEnableSubscriptionConflation() {
        return this.enableSubscriptionConflation;
    }

    @Override
    public boolean getEnableAsyncConflation() {
        return this.enableAsyncConflation;
    }

    @Override
    @Deprecated
    public DiskWriteAttributes getDiskWriteAttributes() {
        return this.diskWriteAttributes;
    }

    @Override
    public abstract File[] getDiskDirs();

    @Override
    public String getDiskStoreName() {
        return this.diskStoreName;
    }

    @Override
    public boolean isDiskSynchronous() {
        return this.isDiskSynchronous;
    }

    @Override
    public boolean getIndexMaintenanceSynchronous() {
        return this.indexMaintenanceSynchronous;
    }

    @Override
    public PartitionAttributes getPartitionAttributes() {
        return this.partitionAttributes;
    }

    @Override
    public MembershipAttributes getMembershipAttributes() {
        return this.membershipAttributes;
    }

    @Override
    public SubscriptionAttributes getSubscriptionAttributes() {
        return this.subscriptionAttributes;
    }

    @Override
    public IndexManager getIndexManager() {
        return this.indexManager;
    }

    @Override
    public void setIndexManager(IndexManager indexManager) {
        this.checkReadiness();
        this.indexManager = indexManager;
    }

    @Override
    public Object getIMSync() {
        return this.imSync;
    }

    public void setFlagForIndexCreationThread(boolean value) {
        isIndexCreator.set(value ? Boolean.TRUE : null);
    }

    @Override
    public boolean isIndexCreationThread() {
        Boolean value = isIndexCreator.get();
        return value != null ? value : false;
    }

    public Region getRegion() {
        return this;
    }

    @Override
    public void addGatewaySenderId(String gatewaySenderId) {
        this.getGatewaySenderIds().add(gatewaySenderId);
        this.setAllGatewaySenderIds();
    }

    @Override
    public void removeGatewaySenderId(String gatewaySenderId) {
        this.getGatewaySenderIds().remove(gatewaySenderId);
        this.setAllGatewaySenderIds();
    }

    @Override
    public void addAsyncEventQueueId(String asyncEventQueueId) {
        this.addAsyncEventQueueId(asyncEventQueueId, false);
    }

    public void addAsyncEventQueueId(String asyncEventQueueId, boolean isInternal) {
        this.getAsyncEventQueueIds().add(asyncEventQueueId);
        if (!isInternal) {
            this.getVisibleAsyncEventQueueIds().add(asyncEventQueueId);
        }
        this.setAllGatewaySenderIds();
    }

    @Override
    public void removeAsyncEventQueueId(String asyncEventQueueId) {
        this.getAsyncEventQueueIds().remove(asyncEventQueueId);
        this.getVisibleAsyncEventQueueIds().remove(asyncEventQueueId);
        this.setAllGatewaySenderIds();
    }

    private void setAllGatewaySenderIds() {
        if (this.getGatewaySenderIds().isEmpty() && this.getAsyncEventQueueIds().isEmpty()) {
            this.allGatewaySenderIds = Collections.emptySet();
        }
        HashSet<String> tmp = new HashSet<String>(this.getGatewaySenderIds());
        for (String asyncQueueId : this.getAsyncEventQueueIds()) {
            tmp.add(AsyncEventQueueImpl.getSenderIdFromAsyncEventQueueId(asyncQueueId));
        }
        this.allGatewaySenderIds = Collections.unmodifiableSet(tmp);
    }

    private void initializeVisibleAsyncEventQueueIds(InternalRegionArguments internalRegionArgs) {
        CopyOnWriteArraySet<String> visibleAsyncEventQueueIds = new CopyOnWriteArraySet<String>(this.getAsyncEventQueueIds());
        if (internalRegionArgs.getInternalAsyncEventQueueIds() != null) {
            visibleAsyncEventQueueIds.removeAll(internalRegionArgs.getInternalAsyncEventQueueIds());
        }
        this.visibleAsyncEventQueueIds = visibleAsyncEventQueueIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheListener(CacheListener aListener) {
        this.checkReadiness();
        if (aListener == null) {
            throw new IllegalArgumentException("addCacheListener parameter was null");
        }
        CacheListener wcl = this.wrapRegionMembershipListener(aListener);
        boolean changed = false;
        Object object = this.clSync;
        synchronized (object) {
            Object[] oldListeners = this.cacheListeners;
            if (oldListeners == null || oldListeners.length == 0) {
                this.cacheListeners = new CacheListener[]{wcl};
                changed = true;
            } else {
                List<CacheListener> listeners = Arrays.asList(oldListeners);
                if (!listeners.contains(aListener)) {
                    this.cacheListeners = (CacheListener[])ArrayUtils.insert(oldListeners, oldListeners.length, wcl);
                }
            }
        }
        if (changed) {
            this.cacheListenersChanged(true);
        }
    }

    private CacheListener wrapRegionMembershipListener(CacheListener listener) {
        if (listener instanceof RegionMembershipListener) {
            return new WrappedRegionMembershipListener((RegionMembershipListener)listener);
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initPostCreateRegionMembershipListeners(Set initialMembers) {
        Object object = this.clSync;
        synchronized (object) {
            DistributedMember[] members = null;
            CacheListener[] newListeners = null;
            for (int i = 0; i < this.cacheListeners.length; ++i) {
                WrappedRegionMembershipListener wrml;
                CacheListener cl = this.cacheListeners[i];
                if (!(cl instanceof WrappedRegionMembershipListener) || (wrml = (WrappedRegionMembershipListener)cl).isInitialized()) continue;
                if (members == null) {
                    members = initialMembers.toArray(new DistributedMember[0]);
                }
                wrml.initialMembers((Region)this, members);
                if (newListeners == null) {
                    newListeners = new CacheListener[this.cacheListeners.length];
                    System.arraycopy(this.cacheListeners, 0, newListeners, 0, newListeners.length);
                }
                newListeners[i] = wrml.getWrappedListener();
            }
            if (newListeners != null) {
                this.cacheListeners = newListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCacheListeners(CacheListener[] newListeners) {
        this.checkReadiness();
        CacheListener[] listenersToAdd = null;
        if (newListeners != null) {
            listenersToAdd = new CacheListener[newListeners.length];
            for (int i = 0; i < newListeners.length; ++i) {
                listenersToAdd[i] = this.wrapRegionMembershipListener(newListeners[i]);
            }
        }
        CacheListener[] cacheListenerArray = this.clSync;
        synchronized (this.clSync) {
            CacheListener[] oldListeners = this.cacheListeners;
            if (listenersToAdd == null || listenersToAdd.length == 0) {
                this.cacheListeners = EMPTY_LISTENERS;
            } else {
                if (Arrays.asList(listenersToAdd).contains(null)) {
                    throw new IllegalArgumentException("initCacheListeners parameter had a null element");
                }
                CacheListener[] newCacheListeners = new CacheListener[listenersToAdd.length];
                System.arraycopy(listenersToAdd, 0, newCacheListeners, 0, newCacheListeners.length);
                this.cacheListeners = newCacheListeners;
            }
            // ** MonitorExit[var4_5] (shouldn't be in output)
            if (listenersToAdd == null || listenersToAdd.length == 0) {
                if (oldListeners != null && oldListeners.length > 0) {
                    for (CacheListener oldListener : oldListeners) {
                        this.closeCacheCallback(oldListener);
                    }
                    this.cacheListenersChanged(false);
                }
            } else if (oldListeners != null && oldListeners.length > 0) {
                for (CacheListener oldListener : oldListeners) {
                    this.closeCacheCallback(oldListener);
                }
            } else {
                this.cacheListenersChanged(true);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheListener(CacheListener aListener) {
        this.checkReadiness();
        if (aListener == null) {
            throw new IllegalArgumentException("removeCacheListener parameter was null");
        }
        boolean changed = false;
        Object object = this.clSync;
        synchronized (object) {
            ArrayList<CacheListener> newListeners;
            CacheListener[] oldListeners = this.cacheListeners;
            if (oldListeners != null && oldListeners.length > 0 && (newListeners = new ArrayList<CacheListener>(Arrays.asList(oldListeners))).remove(aListener)) {
                if (newListeners.isEmpty()) {
                    this.cacheListeners = EMPTY_LISTENERS;
                } else {
                    CacheListener[] newCacheListeners = new CacheListener[newListeners.size()];
                    newListeners.toArray(newCacheListeners);
                    this.cacheListeners = newCacheListeners;
                }
                this.closeCacheCallback(aListener);
                if (newListeners.isEmpty()) {
                    changed = true;
                }
            }
        }
        if (changed) {
            this.cacheListenersChanged(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheLoader setCacheLoader(CacheLoader cacheLoader) {
        this.readWriteLockForCacheLoader.writeLock().lock();
        try {
            this.checkReadiness();
            CacheLoader oldLoader = this.cacheLoader;
            this.cacheLoader = cacheLoader;
            this.cacheLoaderChanged(oldLoader);
            CacheLoader cacheLoader2 = oldLoader;
            return cacheLoader2;
        }
        finally {
            this.readWriteLockForCacheLoader.writeLock().unlock();
        }
    }

    private void assignCacheLoader(CacheLoader cl) {
        this.readWriteLockForCacheLoader.writeLock().lock();
        try {
            this.cacheLoader = cl;
        }
        finally {
            this.readWriteLockForCacheLoader.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheWriter setCacheWriter(CacheWriter cacheWriter) {
        this.readWriteLockForCacheWriter.writeLock().lock();
        try {
            this.checkReadiness();
            CacheWriter oldWriter = this.cacheWriter;
            this.cacheWriter = cacheWriter;
            this.cacheWriterChanged(oldWriter);
            CacheWriter cacheWriter2 = oldWriter;
            return cacheWriter2;
        }
        finally {
            this.readWriteLockForCacheWriter.writeLock().unlock();
        }
    }

    private void assignCacheWriter(CacheWriter cacheWriter) {
        this.readWriteLockForCacheWriter.writeLock().lock();
        try {
            this.cacheWriter = cacheWriter;
        }
        finally {
            this.readWriteLockForCacheWriter.writeLock().unlock();
        }
    }

    void checkEntryTimeoutAction(String mode, ExpirationAction ea) {
        if ((this.getDataPolicy().withReplication() || this.getDataPolicy().withPartitioning()) && (ea == ExpirationAction.LOCAL_DESTROY || ea == ExpirationAction.LOCAL_INVALIDATE)) {
            throw new IllegalArgumentException(String.format("%s action is incompatible with this region's data policy.", mode));
        }
    }

    @Override
    public ExpirationAttributes setEntryIdleTimeout(ExpirationAttributes idleTimeout) {
        this.checkReadiness();
        if (idleTimeout == null) {
            throw new IllegalArgumentException("idleTimeout must not be null");
        }
        this.checkEntryTimeoutAction("idleTimeout", idleTimeout.getAction());
        if (!this.statisticsEnabled) {
            throw new IllegalStateException("Cannot set idle timeout when statistics are disabled.");
        }
        ExpirationAttributes oldAttrs = this.getEntryIdleTimeout();
        this.entryIdleTimeout = idleTimeout.getTimeout();
        this.entryIdleTimeoutExpirationAction = idleTimeout.getAction();
        this.setEntryIdleTimeoutAttributes();
        this.updateEntryExpiryPossible();
        this.idleTimeoutChanged(oldAttrs);
        return oldAttrs;
    }

    public CustomExpiry setCustomEntryIdleTimeout(CustomExpiry custom) {
        this.checkReadiness();
        if (custom != null && !this.statisticsEnabled) {
            throw new IllegalStateException("Cannot set idle timeout when statistics are disabled.");
        }
        CustomExpiry old = this.getCustomEntryIdleTimeout();
        this.customEntryIdleTimeout = custom;
        this.updateEntryExpiryPossible();
        this.idleTimeoutChanged(this.getEntryIdleTimeout());
        return old;
    }

    @Override
    public ExpirationAttributes setEntryTimeToLive(ExpirationAttributes timeToLive) {
        this.checkReadiness();
        if (timeToLive == null) {
            throw new IllegalArgumentException("timeToLive must not be null");
        }
        this.checkEntryTimeoutAction("timeToLive", timeToLive.getAction());
        if (!this.statisticsEnabled) {
            throw new IllegalStateException("Cannot set time to live when statistics are disabled");
        }
        ExpirationAttributes oldAttrs = this.getEntryTimeToLive();
        this.entryTimeToLive = timeToLive.getTimeout();
        this.entryTimeToLiveExpirationAction = timeToLive.getAction();
        this.setEntryTimeToLiveAttributes();
        this.updateEntryExpiryPossible();
        this.timeToLiveChanged(oldAttrs);
        return oldAttrs;
    }

    public CustomExpiry setCustomEntryTimeToLive(CustomExpiry custom) {
        this.checkReadiness();
        if (custom != null && !this.statisticsEnabled) {
            throw new IllegalStateException("Cannot set custom time to live when statistics are disabled");
        }
        CustomExpiry old = this.getCustomEntryTimeToLive();
        this.customEntryTimeToLive = custom;
        this.updateEntryExpiryPossible();
        this.timeToLiveChanged(this.getEntryTimeToLive());
        return old;
    }

    public static void validatePRRegionExpirationAttributes(ExpirationAttributes expAtts) {
        if (expAtts.getTimeout() > 0) {
            ExpirationAction expAction = expAtts.getAction();
            if (expAction.isInvalidate() || expAction.isLocalInvalidate()) {
                throw new IllegalStateException("ExpirationAction INVALIDATE or LOCAL_INVALIDATE for region is not supported for Partitioned Region.");
            }
            if (expAction.isDestroy() || expAction.isLocalDestroy()) {
                throw new IllegalStateException("ExpirationAction DESTROY or LOCAL_DESTROY for region is not supported for Partitioned Region.");
            }
        }
    }

    @Override
    public ExpirationAttributes setRegionIdleTimeout(ExpirationAttributes idleTimeout) {
        this.checkReadiness();
        if (idleTimeout == null) {
            throw new IllegalArgumentException("idleTimeout must not be null");
        }
        if (this.getAttributes().getDataPolicy().withPartitioning()) {
            AbstractRegion.validatePRRegionExpirationAttributes(idleTimeout);
        }
        if (idleTimeout.getAction() == ExpirationAction.LOCAL_INVALIDATE && this.getDataPolicy().withReplication()) {
            throw new IllegalArgumentException(String.format("%s action is incompatible with this region's data policy.", "idleTimeout"));
        }
        if (!this.statisticsEnabled) {
            throw new IllegalStateException("Cannot set idle timeout when statistics are disabled.");
        }
        ExpirationAttributes oldAttrs = this.getRegionIdleTimeout();
        this.regionIdleTimeout = idleTimeout.getTimeout();
        this.regionIdleTimeoutExpirationAction = idleTimeout.getAction();
        this.setRegionIdleTimeoutAttributes();
        this.regionIdleTimeoutChanged(oldAttrs);
        return oldAttrs;
    }

    @Override
    public ExpirationAttributes setRegionTimeToLive(ExpirationAttributes timeToLive) {
        this.checkReadiness();
        if (timeToLive == null) {
            throw new IllegalArgumentException("timeToLive must not be null");
        }
        if (this.getAttributes().getDataPolicy().withPartitioning()) {
            AbstractRegion.validatePRRegionExpirationAttributes(timeToLive);
        }
        if (timeToLive.getAction() == ExpirationAction.LOCAL_INVALIDATE && this.getDataPolicy().withReplication()) {
            throw new IllegalArgumentException(String.format("%s action is incompatible with this region's data policy.", "timeToLive"));
        }
        if (!this.statisticsEnabled) {
            throw new IllegalStateException("Cannot set time to live when statistics are disabled");
        }
        ExpirationAttributes oldAttrs = this.getRegionTimeToLive();
        this.regionTimeToLive = timeToLive.getTimeout();
        this.regionTimeToLiveExpirationAction = timeToLive.getAction();
        this.setRegionTimeToLiveAtts();
        this.regionTimeToLiveChanged(timeToLive);
        return oldAttrs;
    }

    @Override
    public void becomeLockGrantor() {
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        if (this.scope != Scope.GLOBAL) {
            throw new IllegalStateException("Cannot set lock grantor when scope is not global");
        }
        if (this.isCurrentlyLockGrantor()) {
            return;
        }
        this.isLockGrantor = true;
    }

    @Override
    public CacheStatistics getStatistics() {
        this.checkReadiness();
        if (!this.statisticsEnabled) {
            throw new StatisticsDisabledException(String.format("Statistics disabled for region ' %s '", this.getFullPath()));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long getLastModifiedTime() {
        this.checkReadiness();
        long mostRecent = this.basicGetLastModifiedTime();
        LocalRegion.InitializationLevel oldLevel = LocalRegion.setThreadInitLevelRequirement(LocalRegion.InitializationLevel.ANY_INIT);
        try {
            for (Region<?, ?> region : this.subregions(false)) {
                try {
                    LocalRegion localRegion = (LocalRegion)region;
                    if (!localRegion.isInitialized()) continue;
                    mostRecent = Math.max(mostRecent, localRegion.getLastModifiedTime());
                }
                catch (RegionDestroyedException regionDestroyedException) {}
            }
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
        }
        return mostRecent;
    }

    private long basicGetLastModifiedTime() {
        return this.lastModifiedTime.get();
    }

    private long basicGetLastAccessedTime() {
        return this.lastAccessedTime.get();
    }

    private void basicSetLastModifiedTime(long t) {
        this.lastModifiedTime.set(t);
    }

    private void basicSetLastAccessedTime(long t) {
        this.lastAccessedTime.set(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long getLastAccessedTime() {
        this.checkReadiness();
        long mostRecent = this.basicGetLastAccessedTime();
        LocalRegion.InitializationLevel oldLevel = LocalRegion.setThreadInitLevelRequirement(LocalRegion.InitializationLevel.ANY_INIT);
        try {
            for (Region<?, ?> region : this.subregions(false)) {
                try {
                    LocalRegion localRegion = (LocalRegion)region;
                    if (!localRegion.isInitialized()) continue;
                    mostRecent = Math.max(mostRecent, localRegion.getLastAccessedTime());
                }
                catch (RegionDestroyedException regionDestroyedException) {}
            }
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
        }
        return mostRecent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void updateStats() {
        long mostRecentAccessed = this.basicGetLastAccessedTime();
        long mostRecentModified = this.basicGetLastModifiedTime();
        LocalRegion.InitializationLevel oldLevel = LocalRegion.setThreadInitLevelRequirement(LocalRegion.InitializationLevel.ANY_INIT);
        try {
            for (Region<?, ?> region : this.subregions(false)) {
                try {
                    LocalRegion localRegion = (LocalRegion)region;
                    if (!localRegion.isInitialized()) continue;
                    mostRecentAccessed = Math.max(mostRecentAccessed, localRegion.getLastAccessedTime());
                    mostRecentModified = Math.max(mostRecentModified, localRegion.getLastModifiedTime());
                }
                catch (RegionDestroyedException regionDestroyedException) {}
            }
            this.basicSetLastAccessedTime(Math.max(mostRecentAccessed, mostRecentModified));
            this.basicSetLastModifiedTime(mostRecentModified);
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
        }
    }

    protected void setLastModifiedTime(long time) {
        if (time > this.lastModifiedTime.get()) {
            this.lastModifiedTime.set(time);
        }
        if (time > this.lastAccessedTime.get()) {
            this.lastAccessedTime.set(time);
        }
    }

    void setLastAccessedTime(long time, boolean hit) {
        this.lastAccessedTime.set(time);
        if (hit) {
            if (trackHits) {
                this.hitCount.getAndIncrement();
            }
        } else if (trackMisses) {
            this.missCount.getAndIncrement();
        }
    }

    @Override
    public float getHitRatio() {
        long hits = this.getHitCount();
        long total = hits + this.getMissCount();
        return total == 0L ? 0.0f : (float)hits / (float)total;
    }

    @Override
    public long getHitCount() {
        return this.hitCount.get();
    }

    @Override
    public long getMissCount() {
        return this.missCount.get();
    }

    @Override
    public void resetCounts() {
        if (trackMisses) {
            this.missCount.set(0L);
        }
        if (trackHits) {
            this.hitCount.set(0L);
        }
    }

    void closeCacheCallback(CacheCallback cb) {
        if (cb != null) {
            try {
                cb.close();
            }
            catch (RuntimeException ex) {
                logger.warn("CacheCallback close exception", (Throwable)ex);
            }
        }
    }

    protected void cacheLoaderChanged(CacheLoader oldLoader) {
        this.readWriteLockForCacheLoader.readLock().lock();
        try {
            if (this.cacheLoader != oldLoader) {
                this.closeCacheCallback(oldLoader);
            }
        }
        finally {
            this.readWriteLockForCacheLoader.readLock().unlock();
        }
    }

    protected void cacheListenersChanged(boolean nowHasListener) {
    }

    protected void cacheWriterChanged(CacheWriter oldWriter) {
        this.readWriteLockForCacheWriter.readLock().lock();
        try {
            if (this.cacheWriter != oldWriter) {
                this.closeCacheCallback(oldWriter);
            }
        }
        finally {
            this.readWriteLockForCacheWriter.readLock().unlock();
        }
    }

    void timeToLiveChanged(ExpirationAttributes oldTimeToLive) {
    }

    void idleTimeoutChanged(ExpirationAttributes oldIdleTimeout) {
    }

    void regionTimeToLiveChanged(ExpirationAttributes oldTimeToLive) {
    }

    void regionIdleTimeoutChanged(ExpirationAttributes oldIdleTimeout) {
    }

    @Override
    public boolean isProxy() {
        return this.getDataPolicy().isEmpty();
    }

    boolean isCacheContentProxy() {
        return this.isProxy() && this.getSubscriptionAttributes().getInterestPolicy().isCacheContent();
    }

    @Override
    public boolean isAllEvents() {
        return this.getDataPolicy().withReplication() || this.getSubscriptionAttributes().getInterestPolicy().isAll();
    }

    protected void updateEntryExpiryPossible() {
        this.entryExpiryPossible = !this.isProxy() && (this.hasTimeToLive() || this.hasIdleTimeout());
    }

    private boolean hasTimeToLive() {
        return this.entryTimeToLive > 0 || this.customEntryTimeToLive != null;
    }

    private boolean hasIdleTimeout() {
        return this.entryIdleTimeout > 0 || this.customEntryIdleTimeout != null;
    }

    @Override
    public boolean isEntryExpiryPossible() {
        return this.entryExpiryPossible;
    }

    ExpirationAction getEntryExpirationAction() {
        if (this.entryIdleTimeoutExpirationAction != null) {
            return this.entryIdleTimeoutExpirationAction;
        }
        if (this.entryTimeToLiveExpirationAction != null) {
            return this.entryTimeToLiveExpirationAction;
        }
        return null;
    }

    @Override
    public boolean isEntryEvictionPossible() {
        return this.evictionAttributes != null && !this.evictionAttributes.getAlgorithm().isNone();
    }

    protected abstract boolean supportsConcurrencyChecks();

    private PoolImpl getPool() {
        PoolImpl result = null;
        if (this.getPoolName() != null) {
            result = this.poolFinder.find(this.getPoolName());
        }
        return result;
    }

    @Override
    public boolean existsValue(String queryPredicate) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return !this.query(queryPredicate).isEmpty();
    }

    @Override
    public Object selectValue(String queryPredicate) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        SelectResults result = this.query(queryPredicate);
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            throw new FunctionDomainException(String.format("selectValue expects results of size 1, but found results of size %s", result.size()));
        }
        return result.iterator().next();
    }

    @Override
    public EvictionAttributes getEvictionAttributes() {
        return this.evictionAttributes;
    }

    @Override
    public EvictionAttributesMutator getEvictionAttributesMutator() {
        return new EvictionAttributesMutatorImpl(this, this.evictionAttributes);
    }

    protected void checkForNoAccess() {
    }

    public void checkForLimitedOrNoAccess() {
    }

    @Override
    public void handleReliableDistribution(Set successfulRecipients) {
    }

    @Override
    public boolean requiresReliabilityCheck() {
        return false;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public InternalCache getCache() {
        return this.cache;
    }

    @Override
    public long cacheTimeMillis() {
        return this.cache.getInternalDistributedSystem().getClock().cacheTimeMillis();
    }

    @Override
    public RegionService getRegionService() {
        return this.cache;
    }

    @Override
    public DistributionManager getDistributionManager() {
        return this.getSystem().getDistributionManager();
    }

    @Override
    public InternalDistributedSystem getSystem() {
        return this.getCache().getInternalDistributedSystem();
    }

    @Override
    public StatisticsFactory getStatisticsFactory() {
        return this.getSystem();
    }

    public int getDSFID() {
        return 26;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        DataSerializer.writeRegion(this, out);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("fromData is not implemented");
    }

    boolean forceCompaction() {
        throw new UnsupportedOperationException("forceCompaction is not implemented");
    }

    @Override
    public boolean getCloningEnabled() {
        return this.cloningEnable;
    }

    @Override
    public void setCloningEnabled(boolean cloningEnable) {
        this.cloningEnable = cloningEnable;
    }

    public static Object handleNotAvailable(Object object) {
        if (object == Token.NOT_AVAILABLE) {
            object = null;
        }
        return object;
    }

    public InternalCache getGemFireCache() {
        return this.cache;
    }

    @Override
    public InternalCache getInternalCache() {
        return this.cache;
    }

    public RegionSnapshotService getSnapshotService() {
        return new RegionSnapshotServiceImpl(this);
    }

    @Override
    public Compressor getCompressor() {
        return this.compressor;
    }

    @Override
    public ExtensionPoint<Region<?, ?>> getExtensionPoint() {
        return this.extensionPoint;
    }

    @Override
    public boolean getOffHeap() {
        return this.offHeap;
    }

    @Override
    public void incRecentlyUsed() {
    }

    protected StatisticsClock getStatisticsClock() {
        return this.statisticsClock;
    }

    static boolean hasRunningGatewaySender(Set<GatewaySender> senders, GatewaySender sender) {
        return senders.contains(sender) && sender.isRunning();
    }

    @VisibleForTesting
    ConcurrentHashMap<RegionEntry, EntryExpiryTask> getEntryExpiryTasks() {
        return this.entryExpiryTasks;
    }

    protected static interface PoolFinder {
        public PoolImpl find(String var1);
    }
}

